# -*- coding: cp1252 -*-
from header_common import *
from header_scene_props import *
from header_operations import *
from header_triggers import *
from header_sounds import *
from module_constants import *
import string

####################################################################################################################
#  Each scene prop record contains the following fields:
#  1) Scene prop id: used for referencing scene props in other files. The prefix spr_ is automatically added before each scene prop id.
#  2) Scene prop flags. See header_scene_props.py for a list of available flags
#  3) Mesh name: Name of the mesh.
#  4) Physics object name:
#  5) Triggers: Simple triggers that are associated with the scene prop
####################################################################################################################

check_item_use_trigger = (ti_on_scene_prop_use,
    [
      (store_trigger_param_1, ":agent_id"),
      (store_trigger_param_2, ":instance_id"),
      
      #for only server itself-----------------------------------------------------------------------------------------------
      (call_script, "script_use_item", ":instance_id", ":agent_id"),
      #for only server itself-----------------------------------------------------------------------------------------------
      (get_max_players, ":num_players"),                               
      (try_for_range, ":player_no", 1, ":num_players"), #0 is server so starting from 1
        (player_is_active, ":player_no"),
        (multiplayer_send_2_int_to_player, ":player_no", multiplayer_event_use_item, ":instance_id", ":agent_id"),
      (try_end),
    ])

check_sally_door_use_trigger_double = (ti_on_scene_prop_use,
    [
      (store_trigger_param_1, ":agent_id"),
      (store_trigger_param_2, ":instance_id"),

      (agent_get_position, pos1, ":agent_id"),
      (prop_instance_get_starting_position, pos2, ":instance_id"),
      
      (scene_prop_get_slot, ":opened_or_closed", ":instance_id", scene_prop_open_or_close_slot),

      (try_begin),
        #out doors like castle sally door can be opened only from inside, if door coordinate is behind your coordinate. Also it can be closed from both sides.
        
        (prop_instance_get_scene_prop_kind, ":scene_prop_id", ":instance_id"),
        
        (assign, ":can_open_door", 0),
        (try_begin),
          (neg|eq, ":scene_prop_id", "spr_viking_keep_destroy_sally_door_right"),
          (neg|eq, ":scene_prop_id", "spr_viking_keep_destroy_sally_door_left"),
          (neg|eq, ":scene_prop_id", "spr_earth_sally_gate_right"),
          (neg|eq, ":scene_prop_id", "spr_earth_sally_gate_left"),
          
          (position_is_behind_position, pos1, pos2),
          (assign, ":can_open_door", 1),
        (else_try),  
          (this_or_next|eq, ":scene_prop_id", "spr_viking_keep_destroy_sally_door_right"),
          (this_or_next|eq, ":scene_prop_id", "spr_viking_keep_destroy_sally_door_left"),
          (this_or_next|eq, ":scene_prop_id", "spr_earth_sally_gate_right"),
          (eq, ":scene_prop_id", "spr_earth_sally_gate_left"),

          (neg|position_is_behind_position, pos1, pos2),
          (assign, ":can_open_door", 1),
        (try_end),
        
        (this_or_next|eq, ":can_open_door", 1),
        (eq, ":opened_or_closed", 1),
      
        (try_begin),
          #for only server itself-----------------------------------------------------------------------------------------------
          (call_script, "script_use_item", ":instance_id", ":agent_id"),
          #for only server itself-----------------------------------------------------------------------------------------------
          (get_max_players, ":num_players"),                               
          (try_for_range, ":player_no", 1, ":num_players"), #0 is server so starting from 1
            (player_is_active, ":player_no"),
            (multiplayer_send_2_int_to_player, ":player_no", multiplayer_event_use_item, ":instance_id", ":agent_id"),
          (try_end),
        (try_end),
      (try_end),
    ])

check_sally_door_use_trigger = (ti_on_scene_prop_use,
    [
      (store_trigger_param_1, ":agent_id"),
      (store_trigger_param_2, ":instance_id"),

      (agent_get_position, pos1, ":agent_id"),
      (prop_instance_get_starting_position, pos2, ":instance_id"),
      
      (scene_prop_get_slot, ":opened_or_closed", ":instance_id", scene_prop_open_or_close_slot),

      (try_begin),
        #out doors like castle sally door can be opened only from inside, if door coordinate is behind your coordinate. Also it can be closed from both sides.
        (this_or_next|position_is_behind_position, pos1, pos2),
        (eq, ":opened_or_closed", 1),
      
        (try_begin),
          #for only server itself-----------------------------------------------------------------------------------------------
          (call_script, "script_use_item", ":instance_id", ":agent_id"),
          #for only server itself-----------------------------------------------------------------------------------------------
          (get_max_players, ":num_players"),                               
          (try_for_range, ":player_no", 1, ":num_players"), #0 is server so starting from 1
            (player_is_active, ":player_no"),
            (multiplayer_send_2_int_to_player, ":player_no", multiplayer_event_use_item, ":instance_id", ":agent_id"),
          (try_end),
        (try_end),
      (try_end),
    ])

check_castle_door_use_trigger = (ti_on_scene_prop_use,
    [
      (store_trigger_param_1, ":agent_id"),
      (store_trigger_param_2, ":instance_id"),

      (agent_get_position, pos1, ":agent_id"),
      (prop_instance_get_starting_position, pos2, ":instance_id"),
      
      (scene_prop_get_slot, ":opened_or_closed", ":instance_id", scene_prop_open_or_close_slot),

      (try_begin),
        (ge, ":agent_id", 0),
        (agent_get_team, ":agent_team", ":agent_id"),

        #in doors like castle room doors can be opened from both sides, but only defenders can open these doors. Also it can be closed from both sides.
        (this_or_next|eq, ":agent_team", 0),
        (eq, ":opened_or_closed", 1),
      
        (try_begin),
          #for only server itself-----------------------------------------------------------------------------------------------
          (call_script, "script_use_item", ":instance_id", ":agent_id"),
          #for only server itself-----------------------------------------------------------------------------------------------
          (get_max_players, ":num_players"),                               
          (try_for_range, ":player_no", 1, ":num_players"), #0 is server so starting from 1
            (player_is_active, ":player_no"),
            (multiplayer_send_2_int_to_player, ":player_no", multiplayer_event_use_item, ":instance_id", ":agent_id"),
          (try_end),
        (try_end),
      (try_end),
    ])

check_ladder_animate_trigger = (ti_on_scene_prop_is_animating,
    [      
      (store_trigger_param_1, ":instance_id"),
      (store_trigger_param_2, ":remaining_time"),

      (call_script, "script_check_creating_ladder_dust_effect", ":instance_id", ":remaining_time"),
      ])

check_ladder_animation_finish_trigger = (ti_on_scene_prop_animation_finished,
    [
      (store_trigger_param_1, ":instance_id"),

      (prop_instance_enable_physics, ":instance_id", 1),
      ])

scene_props = [
  ("invalid_object",0,"question_mark","0", []),
  ("inventory",sokf_type_container|sokf_place_at_origin,"package","bobaggage", []),
  ("empty", 0, "0", "0", []),
  ("chest_a",sokf_type_container,"chest_gothic","bochest_gothic", []),
  ("container_small_chest",sokf_type_container,"package","bobaggage", []),
  ("container_chest_b",sokf_type_container,"chest_b","bo_chest_b", []),
  ("container_chest_c",sokf_type_container,"chest_c","bo_chest_c", []),
  ("player_chest",sokf_type_container,"player_chest","bo_player_chest", []),
  ("locked_player_chest",0,"player_chest","bo_player_chest", []),

  #treca portes
("1257_earth_gate",sokf_moveable|sokf_show_hit_point_bar|sokf_destructible|spr_use_time(0),"towngate_rectangle_door_right","bo_towngate_rectangle_door_right", [
    #check_sally_door_use_trigger_double,

   (ti_on_init_scene_prop,
    [
      (store_trigger_param_1, ":instance_no"),
      (scene_prop_set_hit_points, ":instance_no", 1000),
    ]),
     
   (ti_on_scene_prop_destroy,
    [
      (play_sound, "snd_dummy_destroyed"),
      
      (assign, ":rotate_side", 86),
      
      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),

        (store_trigger_param_1, ":instance_no"),      
        (store_trigger_param_2, ":attacker_agent_no"),

        (set_fixed_point_multiplier, 100),
        (prop_instance_get_position, pos1, ":instance_no"),

        (try_begin),
          (ge, ":attacker_agent_no", 0),
          (agent_get_position, pos2, ":attacker_agent_no"),
          (try_begin),
            (position_is_behind_position, pos2, pos1),
            (val_mul, ":rotate_side", -1),
          (try_end),
        (try_end),
      
        (init_position, pos3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (position_move_y, pos3, -100),
        (else_try),
          (position_move_y, pos3, 100),
        (try_end),
      
        (position_move_x, pos3, -50),
        (position_transform_position_to_parent, pos4, pos1, pos3),
        (position_move_z, pos4, 100),
        (position_get_distance_to_ground_level, ":height_to_terrain", pos4),
        (val_sub, ":height_to_terrain", 100),
        (assign, ":z_difference", ":height_to_terrain"),
        (val_div, ":z_difference", 3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (val_add, ":rotate_side", ":z_difference"),
        (else_try),
          (val_sub, ":rotate_side", ":z_difference"),
        (try_end),

        (position_rotate_x, pos1, ":rotate_side"),
        (prop_instance_animate_to_position, ":instance_no", pos1, 70), #animate to position 1 in 0.7 second
      (try_end),
    ]),       

    (ti_on_scene_prop_hit,
    [
      (store_trigger_param_1, ":instance_no"),       
      (store_trigger_param_2, ":damage"),
      
      (try_begin),
        (scene_prop_get_hit_points, ":hit_points", ":instance_no"),
        (val_sub, ":hit_points", ":damage"),
        (gt, ":hit_points", 0),
        (play_sound, "snd_dummy_hit"),
      (else_try),
        (neg|multiplayer_is_server),
        (play_sound, "snd_dummy_destroyed"),
      (try_end),

      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),

        (particle_system_burst, "psys_dummy_smoke", pos1, 3),
        (particle_system_burst, "psys_dummy_straw", pos1, 10),
      (try_end),      
    ]),
  ]),

("1257_portcullis",sokf_moveable|sokf_show_hit_point_bar|sokf_destructible|spr_use_time(0),"1257_portcullis_a","bo_1257_portcullis_a", [
    #check_sally_door_use_trigger_double,

   (ti_on_init_scene_prop,
    [
      (store_trigger_param_1, ":instance_no"),
      (scene_prop_set_hit_points, ":instance_no", 10000), #2000
    ]),
     
   (ti_on_scene_prop_destroy,
    [
      (play_sound, "snd_dummy_destroyed"),
      
      (assign, ":rotate_side", 86),
      
      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),

        (store_trigger_param_1, ":instance_no"),      
        (store_trigger_param_2, ":attacker_agent_no"),

        (set_fixed_point_multiplier, 100),
        (prop_instance_get_position, pos1, ":instance_no"),

        (try_begin),
          (ge, ":attacker_agent_no", 0),
          (agent_get_position, pos2, ":attacker_agent_no"),
          (try_begin),
            (position_is_behind_position, pos2, pos1),
            (val_mul, ":rotate_side", -1),
          (try_end),
        (try_end),
      
        (init_position, pos3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (position_move_y, pos3, -100),
        (else_try),
          (position_move_y, pos3, 100),
        (try_end),
      
        (position_move_x, pos3, -50),
        (position_transform_position_to_parent, pos4, pos1, pos3),
        (position_move_z, pos4, 100),
        (position_get_distance_to_ground_level, ":height_to_terrain", pos4),
        (val_sub, ":height_to_terrain", 100),
        (assign, ":z_difference", ":height_to_terrain"),
        (val_div, ":z_difference", 3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (val_add, ":rotate_side", ":z_difference"),
        (else_try),
          (val_sub, ":rotate_side", ":z_difference"),
        (try_end),

        (position_rotate_x, pos1, ":rotate_side"),
        (prop_instance_animate_to_position, ":instance_no", pos1, 70), #animate to position 1 in 0.7 second
      (try_end),
    ]),       

    (ti_on_scene_prop_hit,
    [
      (store_trigger_param_1, ":instance_no"),       
      (store_trigger_param_2, ":damage"),
      
      (try_begin),
        (scene_prop_get_hit_points, ":hit_points", ":instance_no"),
        (val_sub, ":hit_points", ":damage"),
        (gt, ":hit_points", 0),
        (play_sound, "snd_dummy_hit"),
      (else_try),
        (neg|multiplayer_is_server),
        (play_sound, "snd_dummy_destroyed"),
      (try_end),

      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),

        (particle_system_burst, "psys_dummy_smoke", pos1, 3),
        (particle_system_burst, "psys_dummy_straw", pos1, 10),
      (try_end),      
    ]),
  ]),
  
("1257_tavern_door_a",sokf_moveable|sokf_show_hit_point_bar|sokf_destructible|spr_use_time(0),"1257_tavern_door_a","bo_1257_tavern_door_a", [
    #check_castle_door_use_trigger,

   (ti_on_init_scene_prop,
    [
      (store_trigger_param_1, ":instance_no"),
      (scene_prop_set_hit_points, ":instance_no", 5000), #3000
    ]),   

   (ti_on_scene_prop_destroy,
    [
      (play_sound, "snd_dummy_destroyed"),
      
      (assign, ":rotate_side", 86),
      
      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),
		
        (store_trigger_param_1, ":instance_no"),      
        (store_trigger_param_2, ":attacker_agent_no"),

        (set_fixed_point_multiplier, 100),
        (prop_instance_get_position, pos1, ":instance_no"),

        (try_begin),
          (ge, ":attacker_agent_no", 0),
          (agent_get_position, pos2, ":attacker_agent_no"),
          (try_begin),
            (position_is_behind_position, pos2, pos1),
            (val_mul, ":rotate_side", -1),
          (try_end),
        (try_end),
      
        (init_position, pos3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (position_move_y, pos3, -100),
        (else_try),
          (position_move_y, pos3, 100),
        (try_end),
      
        (position_move_x, pos3, -50),
        (position_transform_position_to_parent, pos4, pos1, pos3),
        (position_move_z, pos4, 100),
        (position_get_distance_to_ground_level, ":height_to_terrain", pos4),
        (val_sub, ":height_to_terrain", 100),
        (assign, ":z_difference", ":height_to_terrain"),
        (val_div, ":z_difference", 3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (val_add, ":rotate_side", ":z_difference"),
        (else_try),
          (val_sub, ":rotate_side", ":z_difference"),
        (try_end),

        (position_rotate_x, pos1, ":rotate_side"),
        (prop_instance_animate_to_position, ":instance_no", pos1, 70), #animate to position 1 in 0.7 second
      (try_end),
    ]),       

    (ti_on_scene_prop_hit,
    [
      (store_trigger_param_1, ":instance_no"),       
      (store_trigger_param_2, ":damage"),
      
      (try_begin),
        (scene_prop_get_hit_points, ":hit_points", ":instance_no"),
        (val_sub, ":hit_points", ":damage"),
        (gt, ":hit_points", 0),
        (play_sound, "snd_dummy_hit"),
      (else_try),
        (neg|multiplayer_is_server),
        (play_sound, "snd_dummy_destroyed"),
      (try_end),

      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),

        (particle_system_burst, "psys_dummy_smoke", pos1, 3),
        (particle_system_burst, "psys_dummy_straw", pos1, 10),
      (try_end),      
    ]),
  ]),
  
("1257_tavern_door_b",sokf_moveable|sokf_show_hit_point_bar|sokf_destructible|spr_use_time(0),"1257_tavern_door_b","bo_1257_tavern_door_b", [
    #check_castle_door_use_trigger,

   (ti_on_init_scene_prop,
    [
      (store_trigger_param_1, ":instance_no"),
      (scene_prop_set_hit_points, ":instance_no", 5000), #3000
    ]),   

   (ti_on_scene_prop_destroy,
    [
      (play_sound, "snd_dummy_destroyed"),
      
      (assign, ":rotate_side", 86),
      
      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),
		
        (store_trigger_param_1, ":instance_no"),      
        (store_trigger_param_2, ":attacker_agent_no"),

        (set_fixed_point_multiplier, 100),
        (prop_instance_get_position, pos1, ":instance_no"),

        (try_begin),
          (ge, ":attacker_agent_no", 0),
          (agent_get_position, pos2, ":attacker_agent_no"),
          (try_begin),
            (position_is_behind_position, pos2, pos1),
            (val_mul, ":rotate_side", -1),
          (try_end),
        (try_end),
      
        (init_position, pos3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (position_move_y, pos3, -100),
        (else_try),
          (position_move_y, pos3, 100),
        (try_end),
      
        (position_move_x, pos3, -50),
        (position_transform_position_to_parent, pos4, pos1, pos3),
        (position_move_z, pos4, 100),
        (position_get_distance_to_ground_level, ":height_to_terrain", pos4),
        (val_sub, ":height_to_terrain", 100),
        (assign, ":z_difference", ":height_to_terrain"),
        (val_div, ":z_difference", 3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (val_add, ":rotate_side", ":z_difference"),
        (else_try),
          (val_sub, ":rotate_side", ":z_difference"),
        (try_end),

        (position_rotate_x, pos1, ":rotate_side"),
        (prop_instance_animate_to_position, ":instance_no", pos1, 70), #animate to position 1 in 0.7 second
      (try_end),
    ]),       

    (ti_on_scene_prop_hit,
    [
      (store_trigger_param_1, ":instance_no"),       
      (store_trigger_param_2, ":damage"),
      
      (try_begin),
        (scene_prop_get_hit_points, ":hit_points", ":instance_no"),
        (val_sub, ":hit_points", ":damage"),
        (gt, ":hit_points", 0),
        (play_sound, "snd_dummy_hit"),
      (else_try),
        (neg|multiplayer_is_server),
        (play_sound, "snd_dummy_destroyed"),
      (try_end),

      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),

        (particle_system_burst, "psys_dummy_smoke", pos1, 3),
        (particle_system_burst, "psys_dummy_straw", pos1, 10),
      (try_end),      
    ]),
  ]),
  
("1257_castle_f_door_a",sokf_moveable|sokf_show_hit_point_bar|sokf_destructible|spr_use_time(0),"1257_castle_f_door_a","bo_1257_castle_f_door_a", [
    #check_castle_door_use_trigger,

   (ti_on_init_scene_prop,
    [
      (store_trigger_param_1, ":instance_no"),
      (scene_prop_set_hit_points, ":instance_no", 1000),
    ]),
     
   (ti_on_scene_prop_destroy,
    [
      (play_sound, "snd_dummy_destroyed"),
      
      (assign, ":rotate_side", 86),
      
      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),

        (store_trigger_param_1, ":instance_no"),      
        (store_trigger_param_2, ":attacker_agent_no"),

        (set_fixed_point_multiplier, 100),
        (prop_instance_get_position, pos1, ":instance_no"),

        (try_begin),
          (ge, ":attacker_agent_no", 0),
          (agent_get_position, pos2, ":attacker_agent_no"),
          (try_begin),
            (position_is_behind_position, pos2, pos1),
            (val_mul, ":rotate_side", -1),
          (try_end),
        (try_end),
      
        (init_position, pos3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (position_move_y, pos3, -100),
        (else_try),
          (position_move_y, pos3, 100),
        (try_end),
      
        (position_move_x, pos3, -50),
        (position_transform_position_to_parent, pos4, pos1, pos3),
        (position_move_z, pos4, 100),
        (position_get_distance_to_ground_level, ":height_to_terrain", pos4),
        (val_sub, ":height_to_terrain", 100),
        (assign, ":z_difference", ":height_to_terrain"),
        #(assign, reg0, ":z_difference"),
        #(display_message, "@{!}z dif : {reg0}"),
        (val_div, ":z_difference", 3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (val_add, ":rotate_side", ":z_difference"),
        (else_try),
          (val_sub, ":rotate_side", ":z_difference"),
        (try_end),

        (position_rotate_x, pos1, ":rotate_side"),
        (prop_instance_animate_to_position, ":instance_no", pos1, 70), #animate to position 1 in 0.7 second
      (try_end),
    ]),       
  
    (ti_on_scene_prop_hit,
    [
      (store_trigger_param_1, ":instance_no"),       
      (store_trigger_param_2, ":damage"),
      
      (try_begin),
        (scene_prop_get_hit_points, ":hit_points", ":instance_no"),
        (val_sub, ":hit_points", ":damage"),
        (gt, ":hit_points", 0),
        (play_sound, "snd_dummy_hit"),
      (else_try),
        (neg|multiplayer_is_server),
        (play_sound, "snd_dummy_destroyed"),
      (try_end),

      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),

        (particle_system_burst, "psys_dummy_smoke", pos1, 3),
        (particle_system_burst, "psys_dummy_straw", pos1, 10),
      (try_end),      
    ]),
  ]),
#fin de trenca portes
  
  ("light_sun", sokf_invisible, "light_sphere", "0", [
    (ti_on_scene_prop_init,[
      (neg|is_currently_night),
      (store_trigger_param_1, ":var0"),
      (set_fixed_point_multiplier, 100),
      (prop_instance_get_scale, pos5, ":var0"),
      (position_get_scale_x, ":var1", pos5),
      (store_time_of_day, reg12),
      (try_begin),
        (is_between, reg12, 5, 20),
        (store_mul, ":var2", 1000, ":var1"),
        (store_mul, ":var3", 965, ":var1"),
        (store_mul, ":var4", 900, ":var1"),
      (else_try),
        (store_mul, ":var2", 450, ":var1"),
        (store_mul, ":var3", 575, ":var1"),
        (store_mul, ":var4", 750, ":var1"),
      (try_end),
      (val_div, ":var2", 100),
      (val_div, ":var3", 100),
      (val_div, ":var4", 100),
      (set_current_color, ":var2", ":var3", ":var4"),
      (set_position_delta, 0, 0, 0),
      (add_point_light_to_entity, 0, 0),
    ]),
  ]),

  ("light", sokf_invisible, "light_sphere", "0", [
    (ti_on_scene_prop_init,[
      (store_trigger_param_1, ":var0"),
      (set_fixed_point_multiplier, 100),
      (prop_instance_get_scale, pos5, ":var0"),
      (position_get_scale_x, ":var1", pos5),
      (store_mul, ":var2", 600, ":var1"),
      (store_mul, ":var3", 435, ":var1"),
      (store_mul, ":var4", 135, ":var1"),
      (val_div, ":var2", 100),
      (val_div, ":var3", 100),
      (val_div, ":var4", 100),
      (set_current_color, ":var2", ":var3", ":var4"),
      (set_position_delta, 0, 0, 0),
      (add_point_light_to_entity, 10, 30),
    ]),
  ]),

  ("light_red", sokf_invisible, "light_sphere", "0", [
    (ti_on_scene_prop_init,[
      (store_trigger_param_1, ":var0"),
      (set_fixed_point_multiplier, 100),
      (prop_instance_get_scale, pos5, ":var0"),
      (position_get_scale_x, ":var1", pos5),
      (store_mul, ":var2", 340, ":var1"),
      (store_mul, ":var3", 200, ":var1"),
      (store_mul, ":var4", 60, ":var1"),
      (val_div, ":var2", 100),
      (val_div, ":var3", 100),
      (val_div, ":var4", 100),
      (set_current_color, ":var2", ":var3", ":var4"),
      (set_position_delta, 0, 0, 0),
      (add_point_light_to_entity, 20, 30),
    ]),
  ]),

  ("light_night", sokf_invisible, "light_sphere", "0", [
    (ti_on_scene_prop_init,[
      (is_currently_night, 0),
      (store_trigger_param_1, ":var0"),
      (set_fixed_point_multiplier, 100),
      (prop_instance_get_scale, pos5, ":var0"),
      (position_get_scale_x, ":var1", pos5),
      (store_mul, ":var2", 480, ":var1"),
      (store_mul, ":var3", 435, ":var1"),
      (store_mul, ":var4", 300, ":var1"),
      (val_div, ":var2", 100),
      (val_div, ":var3", 100),
      (val_div, ":var4", 100),
      (set_current_color, ":var2", ":var3", ":var4"),
      (set_position_delta, 0, 0, 0),
      (add_point_light_to_entity, 10, 30),
    ]),
  ]),

  ("torch", 0, "torch_a", "0", [
    (ti_on_scene_prop_init,[
      (set_position_delta, 0, -35, 48),
      (particle_system_add_new, "psys_torch_fire"),
      (particle_system_add_new, "psys_torch_smoke"),
      (particle_system_add_new, "psys_torch_fire_sparks"),
      (play_sound, "snd_torch_loop", 0),
      (set_position_delta, 0, -35, 56),
      (particle_system_add_new, "psys_fire_glow_1"),
      (get_trigger_object_position, pos2),
      (set_position_delta, 0, 0, 0),
      (position_move_y, pos2, -35),
      (position_move_z, pos2, 55),
      (particle_system_burst, "psys_fire_glow_fixed", pos2, 1),
    ]),
  ]),

  ("torch_night", 0, "torch_a", "0", [
    (ti_on_scene_prop_init,[
      (is_currently_night, 0),
      (set_position_delta, 0, -35, 48),
      (particle_system_add_new, "psys_torch_fire"),
      (particle_system_add_new, "psys_torch_smoke"),
      (particle_system_add_new, "psys_torch_fire_sparks"),
      (set_position_delta, 0, -35, 56),
      (particle_system_add_new, "psys_fire_glow_1"),
      (particle_system_emit, "psys_fire_glow_1", 9000000),
      (play_sound, "snd_torch_loop", 0),
    ]),
  ]),
#  ("Baggage",sokf_place_at_origin|sokf_entity_body,"package","bobaggage"),
  ("barrier_20m",sokf_invisible|sokf_type_barrier,"barrier_20m","bo_barrier_20m", []),
  ("barrier_16m",sokf_invisible|sokf_type_barrier,"barrier_16m","bo_barrier_16m", []),
  ("barrier_8m" ,sokf_invisible|sokf_type_barrier,"barrier_8m" ,"bo_barrier_8m" , []),
  ("barrier_4m" ,sokf_invisible|sokf_type_barrier,"barrier_4m" ,"bo_barrier_4m" , []),
  ("barrier_2m" ,sokf_invisible|sokf_type_barrier,"barrier_2m" ,"bo_barrier_2m" , []),
  
  ("exit_4m" ,sokf_invisible|sokf_type_barrier_leave,"barrier_4m" ,"bo_barrier_4m" , []),
  ("exit_8m" ,sokf_invisible|sokf_type_barrier_leave,"barrier_8m" ,"bo_barrier_8m" , []),
  ("exit_16m" ,sokf_invisible|sokf_type_barrier_leave,"barrier_16m" ,"bo_barrier_16m" , []),

  ("ai_limiter_2m" ,sokf_invisible|sokf_type_ai_limiter,"barrier_2m" ,"bo_barrier_2m" , []),
  ("ai_limiter_4m" ,sokf_invisible|sokf_type_ai_limiter,"barrier_4m" ,"bo_barrier_4m" , []),
  ("ai_limiter_8m" ,sokf_invisible|sokf_type_ai_limiter,"barrier_8m" ,"bo_barrier_8m" , []),
  ("ai_limiter_16m",sokf_invisible|sokf_type_ai_limiter,"barrier_16m","bo_barrier_16m", []),
  ("Shield",sokf_dynamic,"0","boshield", []),
  ("shelves",0,"shelves","boshelves", []),
  ("table_tavern",0,"table_tavern","botable_tavern", []),
  ("table_castle_a",0,"table_castle_a","bo_table_castle_a", []),
  ("chair_castle_a",0,"chair_castle_a","bo_chair_castle_a", []),

  ("pillow_a",0,"pillow_a","bo_pillow", []),
  ("pillow_b",0,"pillow_b","bo_pillow", []),
  ("pillow_c",0,"pillow_c","0", []),


  ("interior_castle_g_square_keep_b",0,"interior_castle_g_square_keep_b","bo_interior_castle_g_square_keep_b", []),



  ("carpet_with_pillows_a",0,"carpet_with_pillows_a","bo_carpet_with_pillows", []),
  ("carpet_with_pillows_b",0,"carpet_with_pillows_b","bo_carpet_with_pillows", []),
  ("table_round_a",0,"table_round_a","bo_table_round_a", []),
  ("table_round_b",0,"table_round_b","bo_table_round_b", []),
  ("fireplace_b",0,"fireplace_b","bo_fireplace_b", []),
  ("fireplace_c",0,"fireplace_c","bo_fireplace_c", []),

  ("sofa_a",0,"sofa_a","bo_sofa", []),
  ("sofa_b",0,"sofa_b","bo_sofa", []),
  ("ewer_a",0,"ewer_a","bo_ewer_a", []),
  ("end_table_a",0,"end_table_a","bo_end_table_a", []),


  ("fake_houses_steppe_a",0,"fake_houses_steppe_a","0", []),
  ("fake_houses_steppe_b",0,"fake_houses_steppe_b","0", []),
  ("fake_houses_steppe_c",0,"fake_houses_steppe_c","0", []),
  
#CWE
  ("fake_block_a", 0, "fake_block_a", "0", []),
  ("fake_block_b", 0, "fake_block_b", "0", []),
  ("fake_block_c", 0, "fake_block_c", "0", []),
  ("fake_n_hous_mod_a", 0, "fake_houses_steppe_a", "0", []),
  ("fake_n_hous_mod_b", 0, "fake_houses_steppe_b", "0", []),
  ("fake_n_hous_mod_c", 0, "fake_houses_steppe_c", "0", []),
  ("fake_n_hous_mod_d", 0, "fake_houses_steppe_a", "0", []),
  ("fake_sa_house_a", 0, "fake_houses_steppe_a", "0", []),
  ("fake_sa_house_b", 0, "fake_houses_steppe_b", "0", []),
  ("fake_sa_house_c", 0, "fake_houses_steppe_c", "0", []),
  ("fake_sa_house_d", 0, "fake_houses_steppe_a", "0", []),
  ("fake_sa_house_e", 0, "fake_houses_steppe_b", "0", []),
  ("fake_sa_house_f", 0, "fake_houses_steppe_c", "0", []),
  ("fake_sa_house_g", 0, "fake_houses_steppe_a", "0", []),
  ("fake_sa_house_s", 0, "fake_houses_steppe_b", "0", []),
  ("fake_sa_house_j", 0, "fake_houses_steppe_c", "0", []),
  ("fake_quarter_1", 0, "fake_quarter_1", "0", []),
  ("fake_minaret_a", 0, "fake_minaret_a", "0", []),
  ("fake_minaret_b", 0, "fake_minaret_b", "0", []),
#CWE end  

  ("boat_destroy",0,"boat_destroy","bo_boat_destroy", []),
  ("destroy_house_a",0,"destroy_house_a","bo_destroy_house_a", []),
  ("destroy_house_b",0,"destroy_house_b","bo_destroy_house_b", []),
  ("destroy_house_c",0,"destroy_house_c","bo_destroy_house_c", []),
  ("destroy_heap",0,"destroy_heap","bo_destroy_heap", []),
  ("destroy_castle_a",0,"destroy_castle_a","bo_destroy_castle_a", []),
  ("destroy_castle_b",0,"destroy_castle_b","bo_destroy_castle_b", []),
  
  ("destroy_castle_c",0,"destroy_castle_c","bo_destroy_castle_c", []),
  
  ("destroy_castle_d",0,"destroy_castle_d","bo_destroy_castle_d", []),
  ("destroy_windmill",0,"destroy_windmill","bo_destroy_windmill", []),
  ("destroy_tree_a",0,"destroy_tree_a","bo_destroy_tree_a", []),
  ("destroy_tree_b",0,"destroy_tree_b","bo_destroy_tree_b", []),  
  ("destroy_bridge_a",0,"destroy_bridge_a","bo_destroy_bridge_a", []),  
  ("destroy_bridge_b",0,"destroy_bridge_b","bo_destroy_bridge_b", []),  


  ("catapult",0,"Catapult","bo_Catapult", []),
  
  ("catapult_destructible",sokf_moveable|sokf_show_hit_point_bar|sokf_destructible,"Catapult","bo_Catapult", [
   (ti_on_init_scene_prop,
    [
      (store_trigger_param_1, ":instance_no"),
      (scene_prop_set_hit_points, ":instance_no", 1600),
    ]),
     
   (ti_on_scene_prop_destroy,
    [          
      (play_sound, "snd_dummy_destroyed"),

      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),


        (store_trigger_param_1, ":instance_no"),      
        (prop_instance_get_position, pos1, ":instance_no"),
        (particle_system_burst, "psys_dummy_smoke_big", pos1, 100),
        (particle_system_burst, "psys_dummy_straw_big", pos1, 100),      
        (position_move_z, pos1, -500),
        (position_rotate_x, pos1, 90),
        (prop_instance_animate_to_position, ":instance_no", pos1, 300), #animate to 6 meters below in 6 second

        (try_begin),
          (eq, "$g_round_ended", 0),
          (scene_prop_get_team, ":scene_prop_team_no", ":instance_no"),
          (try_begin),
            (eq, ":scene_prop_team_no", 0),
            (assign, ":scene_prop_team_no_multiplier", -1), 
          (else_try),
            (assign, ":scene_prop_team_no_multiplier", 1), 
          (try_end),

          (try_begin),
            (eq, "$g_number_of_targets_destroyed", 0),        
            (store_mul, ":target_no_mul_scene_prop_team", ":scene_prop_team_no_multiplier", 1), #1 means destroyed object is a catapult
            #for only server itself-----------------------------------------------------------------------------------------------                                                                                                      
            (call_script, "script_show_multiplayer_message", multiplayer_message_type_target_destroyed, ":target_no_mul_scene_prop_team"), 
            #for only server itself-----------------------------------------------------------------------------------------------     
            (get_max_players, ":num_players"),                               
            (try_for_range, ":player_no", 1, ":num_players"),
              (player_is_active, ":player_no"),
              (multiplayer_send_2_int_to_player, ":player_no", multiplayer_event_show_multiplayer_message, multiplayer_message_type_target_destroyed, ":target_no_mul_scene_prop_team"), 
            (try_end),
            (val_add, "$g_number_of_targets_destroyed", 1),
          (else_try),
            (store_mul, ":target_no_mul_scene_prop_team", ":scene_prop_team_no_multiplier", 9), #9 means attackers destroyed all targets
            #for only server itself-----------------------------------------------------------------------------------------------      
            (call_script, "script_show_multiplayer_message", multiplayer_message_type_target_destroyed, ":target_no_mul_scene_prop_team"), 
            #for only server itself-----------------------------------------------------------------------------------------------     
            (get_max_players, ":num_players"),                               
            (try_for_range, ":player_no", 1, ":num_players"),
              (player_is_active, ":player_no"),
              (multiplayer_send_2_int_to_player, ":player_no", multiplayer_event_show_multiplayer_message, multiplayer_message_type_target_destroyed, ":target_no_mul_scene_prop_team"), 
            (try_end),
            (val_add, "$g_number_of_targets_destroyed", 1),
          (try_end),
        (try_end),

        #giving gold for destroying target (for catapult)
        #step-1 calculating total damage given to that scene prop
        (assign, ":total_damage_given", 0),
        (get_max_players, ":num_players"),                               
        (try_for_range, ":player_no", 0, ":num_players"), 
          (player_is_active, ":player_no"),
          
          (try_begin),
            (eq, "spr_catapult_destructible", "$g_destructible_target_1"),
            (player_get_slot, ":damage_given", ":player_no", slot_player_damage_given_to_target_1),
          (else_try),
            (player_get_slot, ":damage_given", ":player_no", slot_player_damage_given_to_target_2),
          (try_end),

          (val_add, ":total_damage_given", ":damage_given"),
        (try_end),

        #step-2 sharing 1000 gold (if num active players < 20 then 50 * num active players) to players which gave damage with the damage amounts.
        (assign, ":destroy_money_addition", 0),
        (get_max_players, ":num_players"),                               
        (try_for_range, ":player_no", 0, ":num_players"), 
          (player_is_active, ":player_no"),
          (val_add, ":destroy_money_addition", 50),
        (try_end),
      
        (try_begin),
          (ge, ":destroy_money_addition", multi_destroy_target_money_add),
          (assign, ":destroy_money_addition", multi_destroy_target_money_add),
        (try_end),
        (val_mul, ":destroy_money_addition", "$g_multiplayer_battle_earnings_multiplier"),
        (val_div, ":destroy_money_addition", 100),
      
        (get_max_players, ":num_players"),                               
        (try_for_range, ":player_no", 0, ":num_players"), 
          (player_is_active, ":player_no"),
          
          (try_begin),
            (eq, "spr_catapult_destructible", "$g_destructible_target_1"),
            (player_get_slot, ":damage_given", ":player_no", slot_player_damage_given_to_target_1),
          (else_try),
            (player_get_slot, ":damage_given", ":player_no", slot_player_damage_given_to_target_2),
          (try_end),

          (player_get_gold, ":player_gold", ":player_no"), #give money to player which helped flag to be owned by new_flag_owner team

          (val_mul, ":damage_given", ":destroy_money_addition"),

          (try_begin),
            (ge, ":total_damage_given", ":damage_given"),
            (gt, ":damage_given", 0),
            (store_div, ":gold_earned", ":damage_given", ":total_damage_given"),
          (else_try),
            (assign, ":gold_earned", 0),
          (try_end),
        
          (val_add, ":player_gold", ":gold_earned"),
          (player_set_gold, ":player_no", ":player_gold", multi_max_gold_that_can_be_stored),              
        (try_end),
      (try_end),
    ]),     

    (ti_on_scene_prop_hit,
    [
      (store_trigger_param_1, ":instance_no"),       
      (store_trigger_param_2, ":damage"),
      
      (try_begin),
        (scene_prop_get_hit_points, ":hit_points", ":instance_no"),
        (val_sub, ":hit_points", ":damage"),
        (gt, ":hit_points", 0),
        (play_sound, "snd_dummy_hit"),
      (else_try),
        (neg|multiplayer_is_server),
        (play_sound, "snd_dummy_destroyed"),
      (try_end),

      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),

        (particle_system_burst, "psys_dummy_smoke", pos1, 3),
        (particle_system_burst, "psys_dummy_straw", pos1, 10),
        (set_fixed_point_multiplier, 1),
        (position_get_x, ":attacker_agent_id", pos2),
        (try_begin),
          (ge, ":attacker_agent_id", 0),
          (agent_is_alive, ":attacker_agent_id"),
          (agent_is_human, ":attacker_agent_id"),
          (neg|agent_is_non_player, ":attacker_agent_id"),
          (agent_get_player_id, ":attacker_player_id", ":attacker_agent_id"),
          (ge, ":attacker_player_id", 0),
          (player_is_active, ":attacker_player_id"),        
          (try_begin),
            (eq, "spr_catapult_destructible", "$g_destructible_target_1"),
            (player_get_slot, ":damage_given", ":attacker_player_id", slot_player_damage_given_to_target_1),
            (val_add, ":damage_given", ":damage"),
            (player_set_slot, ":attacker_player_id", slot_player_damage_given_to_target_1, ":damage_given"),
          (else_try),
            (player_get_slot, ":damage_given", ":attacker_player_id", slot_player_damage_given_to_target_2),
            (val_add, ":damage_given", ":damage"),
            (player_set_slot, ":attacker_player_id", slot_player_damage_given_to_target_2, ":damage_given"),
          (try_end),
        (try_end),
      (try_end),
    ]),
  ]),
  
  ("broom",0,"broom","0", []),
  ("garlic",0,"garlic","0", []),
  ("garlic_b",0,"garlic_b","0", []),

  ("destroy_a",0,"destroy_a","0", []),
  ("destroy_b",0,"destroy_b","0", []),



  ("bridge_wooden",0,"bridge_wooden","bo_bridge_wooden", []),
  ("bridge_wooden_snowy",0,"bridge_wooden_snowy","bo_bridge_wooden", []),
  
  ("grave_a",0,"grave_a","bo_grave_a", []),

  
  ("village_house_e",0,"village_house_e","bo_village_house_e", []),
  ("village_house_f",0,"village_house_f","bo_village_house_f", []),
  ("village_house_g",0,"village_house_g","bo_village_house_g", []),
  ("village_house_h",0,"village_house_h","bo_village_house_h", []),
  ("village_house_i",0,"village_house_i","bo_village_house_i", []),
  ("village_house_j",0,"village_house_j","bo_village_house_j", []),
  ("village_wall_a",0,"village_wall_a","bo_village_wall_a", []),
  ("village_wall_b",0,"village_wall_b","bo_village_wall_b", []),

  ("village_snowy_house_a",0,"village_snowy_house_a","bo_village_snowy_house_a", []),  
  ("village_snowy_house_b",0,"village_snowy_house_b","bo_village_snowy_house_b", []),
  ("village_snowy_house_c",0,"village_snowy_house_c","bo_village_snowy_house_c", []),
  ("village_snowy_house_d",0,"village_snowy_house_d","bo_village_snowy_house_d", []),
  ("village_snowy_house_e",0,"village_snowy_house_e","bo_village_snowy_house_e", []),
  ("village_snowy_house_f",0,"village_snowy_house_f","bo_village_snowy_house_f", []),

  ("village_sur_house_g",0,"village_sur_house_g","bo_village_house_g", []),  
  ("village_sur_house_h",0,"village_sur_house_h","bo_village_house_h", []),
  ("village_sur_house_i",0,"village_sur_house_i","bo_village_house_i", []),
  ("village_sur_shed_b",0,"village_sur_shed_b","bo_village_shed_b", []),
  ("village_sur_house_j",0,"village_sur_house_j","bo_village_house_j", []),
  ("almohad_tower",0,"almohad_tower","bo_almohad_tower", []),

  ("town_house_steppe_a",0,"town_house_steppe_a","bo_town_house_steppe_a", []),
  ("town_house_steppe_b",0,"town_house_steppe_b","bo_town_house_steppe_b", []),
  ("town_house_steppe_c",0,"town_house_steppe_c","bo_town_house_steppe_c", []),
  ("town_house_steppe_d",0,"town_house_steppe_d","bo_town_house_steppe_d", []),
  ("town_house_steppe_e",0,"town_house_steppe_e","bo_town_house_steppe_e", []),
  ("town_house_steppe_f",0,"town_house_steppe_f","bo_town_house_steppe_f", []),
  ("town_house_steppe_g",0,"town_house_steppe_g","bo_town_house_steppe_g", []),
  ("town_house_steppe_h",0,"town_house_steppe_h","bo_town_house_steppe_h", []),
  ("town_house_steppe_i",0,"town_house_steppe_i","bo_town_house_steppe_i", []),

  ("carpet_a",0,"carpet_a","0", []),
  ("carpet_b",0,"carpet_b","0", []),
  ("carpet_c",0,"carpet_c","0", []),
  ("carpet_d",0,"carpet_d","0", []),
  ("carpet_e",0,"carpet_e","0", []),
  ("carpet_f",0,"carpet_f","0", []),

  ("awning_a",0,"awning_a","bo_awning", []),
  ("awning_b",0,"awning_b","bo_awning", []),
  ("awning_c",0,"awning_c","bo_awning", []),
  ("awning_long",0,"awning_long","bo_awning_long", []),
  ("awning_long_b",0,"awning_long_b","bo_awning_long", []),
  ("awning_d",0,"awning_d","bo_awning_d", []),


  ("ship",0,"ship","bo_ship", []),

  ("ship_b",0,"ship_b","bo_ship_b", []),
  ("ship_c",0,"ship_c","bo_ship_c", []),



  ("ship_d",0,"ship_d","bo_ship_d", []),

  ("snowy_barrel_a",0,"snowy_barrel_a","bo_snowy_barrel_a", []),
  ("snowy_fence",0,"snowy_fence","bo_snowy_fence", []),
  ("snowy_wood_heap",0,"snowy_wood_heap","bo_snowy_wood_heap", []),

  ("village_snowy_stable_a",0,"village_snowy_stable_a","bo_village_snowy_stable_a", []),

  ("cypress_c",0,"cypress_c","bo_cypress_c", []),
  ("cypress_a",0,"cypress_a","bo_cypress_c", []),
  ("moorish_mosque",0,"moorish_mosque","bo_moorish_mosque", []),

  ("moorish_minaret",0,"moorish_minaret","bo_moorish_minaret", []),

  ("village_straw_house_a",0,"village_straw_house_a","bo_village_straw_house_a", []),
  ("village_stable_a",0,"village_stable_a","bo_village_stable_a", []),
  ("village_shed_a",0,"village_shed_a","bo_village_shed_a", []),
  ("village_shed_b",0,"village_shed_b","bo_village_shed_b", []),

  ("dungeon_door_cell_a",0,"dungeon_door_cell_a","bo_dungeon_door_cell_a", []),
  ("dungeon_door_cell_b",0,"dungeon_door_cell_b","bo_dungeon_door_cell_b", []),
  ("dungeon_door_entry_a",0,"dungeon_door_entry_a","bo_dungeon_door_entry_a", []),
  ("dungeon_door_entry_b",0,"dungeon_door_entry_b","bo_dungeon_door_entry_a", []),
  ("dungeon_door_entry_c",0,"dungeon_door_entry_c","bo_dungeon_door_entry_a", []),
  ("dungeon_door_direction_a",0,"dungeon_door_direction_a","bo_dungeon_door_direction_a", []),
  ("dungeon_door_direction_b",0,"dungeon_door_direction_b","bo_dungeon_door_direction_a", []),
  ("dungeon_door_stairs_a",0,"dungeon_door_stairs_a","bo_dungeon_door_stairs_a", []),
  ("dungeon_door_stairs_b",0,"dungeon_door_stairs_b","bo_dungeon_door_stairs_a", []),
  ("dungeon_bed_a",0,"dungeon_bed_a","0", []),
  ("dungeon_bed_b",0,"dungeon_bed_b","bo_dungeon_bed_b", []),
  ("torture_tool_a",0,"torture_tool_a","bo_torture_tool_a", []),
  ("torture_tool_b",0,"torture_tool_b","0", []),
  ("torture_tool_c",0,"torture_tool_c","bo_torture_tool_c", []),
  ("skeleton_head",0,"skeleton_head","0", []),
  ("skeleton_bone",0,"skeleton_bone","0", []),
  ("skeleton_a",0,"skeleton_a","bo_skeleton_a", []),
  ("dungeon_stairs_a",sokf_type_ladder,"dungeon_stairs_a","bo_dungeon_stairs_a", []),
  ("dungeon_stairs_b",sokf_type_ladder,"dungeon_stairs_b","bo_dungeon_stairs_a", []),
  ("dungeon_torture_room_a",0,"dungeon_torture_room_a","bo_dungeon_torture_room_a", []),
  ("dungeon_entry_a",0,"dungeon_entry_a","bo_dungeon_entry_a", []),
  ("dungeon_entry_b",0,"dungeon_entry_b","bo_dungeon_entry_b", []),
  ("dungeon_entry_c",0,"dungeon_entry_c","bo_dungeon_entry_c", []),
  ("dungeon_cell_a",0,"dungeon_cell_a","bo_dungeon_cell_a", []),
  ("dungeon_cell_b",0,"dungeon_cell_b","bo_dungeon_cell_b", []),
  ("dungeon_cell_c",0,"dungeon_cell_c","bo_dungeon_cell_c", []),
  ("dungeon_corridor_a",0,"dungeon_corridor_a","bo_dungeon_corridor_a", []),
  ("dungeon_corridor_b",0,"dungeon_corridor_b","bo_dungeon_corridor_b", []),
  ("dungeon_corridor_c",0,"dungeon_corridor_c","bo_dungeon_corridor_b", []),
  ("dungeon_corridor_d",0,"dungeon_corridor_d","bo_dungeon_corridor_b", []),
  ("dungeon_direction_a",0,"dungeon_direction_a","bo_dungeon_direction_a", []),
  ("dungeon_direction_b",0,"dungeon_direction_b","bo_dungeon_direction_a", []),
  ("dungeon_room_a",0,"dungeon_room_a","bo_dungeon_room_a", []),
  ("dungeon_tower_stairs_a",sokf_type_ladder,"dungeon_tower_stairs_a","bo_dungeon_tower_stairs_a", []),
  ("dungeon_tower_cell_a",0,"dungeon_tower_cell_a","bo_dungeon_tower_cell_a", []),
  ("tunnel_a",0,"tunnel_a","bo_tunnel_a", []),
  ("tunnel_salt",0,"tunnel_salt","bo_tunnel_salt", []),
  ("salt_a",0,"salt_a","bo_salt_a", []),

  ("door_destructible",sokf_moveable|sokf_show_hit_point_bar|sokf_destructible|spr_use_time(2),"tutorial_door_a","bo_tutorial_door_a", [
    check_item_use_trigger,

   (ti_on_init_scene_prop,
    [
      (store_trigger_param_1, ":instance_no"),
      (scene_prop_set_hit_points, ":instance_no", 2000),
    ]),
     
   (ti_on_scene_prop_destroy,
    [
      (play_sound, "snd_dummy_destroyed"),
      
      (assign, ":rotate_side", 86),
      
      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),

        (store_trigger_param_1, ":instance_no"),      
        (store_trigger_param_2, ":attacker_agent_no"),

        (set_fixed_point_multiplier, 100),
        (prop_instance_get_position, pos1, ":instance_no"),

        (try_begin),
          (ge, ":attacker_agent_no", 0),
          (agent_get_position, pos2, ":attacker_agent_no"),
          (try_begin),
            (position_is_behind_position, pos2, pos1),
            (val_mul, ":rotate_side", -1),
          (try_end),
        (try_end),
      
        (init_position, pos3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (position_move_y, pos3, -100),
        (else_try),
          (position_move_y, pos3, 100),
        (try_end),
      
        (position_move_x, pos3, -50),
        (position_transform_position_to_parent, pos4, pos1, pos3),
        (position_move_z, pos4, 100),
        (position_get_distance_to_ground_level, ":height_to_terrain", pos4),
        (val_sub, ":height_to_terrain", 100),
        (assign, ":z_difference", ":height_to_terrain"),
        (val_div, ":z_difference", 3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (val_add, ":rotate_side", ":z_difference"),
        (else_try),
          (val_sub, ":rotate_side", ":z_difference"),
        (try_end),

        (position_rotate_x, pos1, ":rotate_side"),
        (prop_instance_animate_to_position, ":instance_no", pos1, 70), #animate to position 1 in 0.7 second
      (try_end),
    ]),       

    (ti_on_scene_prop_hit,
    [
      (play_sound, "snd_dummy_hit"),
      (particle_system_burst, "psys_dummy_smoke", pos1, 3),
      (particle_system_burst, "psys_dummy_straw", pos1, 10),      
    ]),
  ]),

  ("tutorial_door_a",sokf_moveable,"tutorial_door_a","bo_tutorial_door_a", []),

  ("tutorial_door_b",sokf_moveable,"tutorial_door_b","bo_tutorial_door_b", []),

  ("tutorial_flag_yellow",sokf_moveable|sokf_face_player,"tutorial_flag_yellow","0", []),
  ("tutorial_flag_red",sokf_moveable|sokf_face_player,"tutorial_flag_red","0", []),
  ("tutorial_flag_blue",sokf_moveable|sokf_face_player,"tutorial_flag_blue","0", []),

  ("interior_prison_a",0,"interior_prison_a","bo_interior_prison_a", []),
  ("interior_prison_b",0,"interior_prison_b","bo_interior_prison_b", []),
  ("interior_prison_cell_a",0,"interior_prison_cell_a","bo_interior_prison_cell_a", []),
  ("interior_prison_d",0,"interior_prison_d","bo_interior_prison_d", []),  

  ("arena_archery_target_a",0,"arena_archery_target_a","bo_arena_archery_target_a", []),
  ("archery_butt_a",0,"archery_butt","bo_archery_butt", [
   (ti_on_scene_prop_hit,
    [
        (store_trigger_param_1, ":instance_no"),
        (prop_instance_get_position, pos2, ":instance_no"),
        (get_player_agent_no, ":player_agent"),
        (agent_get_position, pos3, ":player_agent"),
        (get_distance_between_positions, ":player_distance", pos3, pos2),
        (position_transform_position_to_local, pos4, pos2, pos1),
        (position_set_y, pos4, 0),
        (position_set_x, pos2, 0),
        (position_set_y, pos2, 0),
        (position_set_z, pos2, 0),
        (get_distance_between_positions, ":target_distance", pos4, pos2),
        (assign, ":point_earned", 43), #Calculating a point between 0-12
        (val_sub, ":point_earned", ":target_distance"),
        (val_mul, ":point_earned", 1299),
        (val_div, ":point_earned", 4300),
        (try_begin),
          (lt, ":point_earned", 0),
          (assign, ":point_earned", 0),
        (try_end),
        (val_div, ":player_distance", 91), #Converting to yards
        (assign, reg60, ":point_earned"),
        (assign, reg61, ":player_distance"),
        (display_message, "str_archery_target_hit"),
    ]),
  ]),
  ("archery_target_with_hit_a",0,"arena_archery_target_a","bo_arena_archery_target_a", [
   (ti_on_scene_prop_hit,
    [
        (set_fixed_point_multiplier, 100),
        (store_trigger_param_1, ":instance_no"),
        (position_get_x, ":attacker_agent_id", pos2),
        (val_div, ":attacker_agent_id", 100),
        (get_player_agent_no, ":player_agent"),
        (try_begin),
          (eq, ":player_agent", ":attacker_agent_id"),
          (prop_instance_get_position, pos2, ":instance_no"),
          (agent_get_position, pos3, ":player_agent"),
          (get_distance_between_positions, ":player_distance", pos3, pos2),
          (position_transform_position_to_local, pos4, pos2, pos1),
          (position_set_y, pos4, 0),
          (position_set_x, pos2, 0),
          (position_set_y, pos2, 0),
          (position_set_z, pos2, 0),
          (get_distance_between_positions, ":target_distance", pos4, pos2),
          (assign, ":point_earned", 43), #Calculating a point between 0-12
          (val_sub, ":point_earned", ":target_distance"),
          (val_mul, ":point_earned", 1299),
          (val_div, ":point_earned", 4300),
          (try_begin),
            (lt, ":point_earned", 0),
            (assign, ":point_earned", 0),
          (try_end),
          (assign, "$g_last_archery_point_earned", ":point_earned"),
          (val_div, ":player_distance", 91), #Converting to yards
          (assign, reg60, ":point_earned"),
          (assign, reg61, ":player_distance"),
          (display_message, "str_archery_target_hit"),
          (eq, "$g_tutorial_training_ground_horseman_trainer_state", 6),
          (eq, "$g_tutorial_training_ground_horseman_trainer_completed_chapters", 2),
          (prop_instance_get_variation_id_2, ":var_id_2", ":instance_no"),
          (val_sub, ":var_id_2", 1),
          (eq, "$g_tutorial_training_ground_current_score", ":var_id_2"),
          (val_add, "$g_tutorial_training_ground_current_score", 1),
        (try_end),
    ]),
  ]),
  ("dummy_a",sokf_destructible|sokf_moveable,"arena_archery_target_b","bo_arena_archery_target_b",   [
   (ti_on_scene_prop_destroy,
    [
        (store_trigger_param_1, ":instance_no"),
        (prop_instance_get_starting_position, pos1, ":instance_no"),
        (get_player_agent_no, ":player_agent"),
        (agent_get_position, 2, ":player_agent"),
        (assign, ":rotate_side", 80),
        (try_begin),
          (position_is_behind_position, 2, 1),
          (val_mul, ":rotate_side", -1),
        (try_end),
        (position_rotate_x, 1, ":rotate_side"),
        (prop_instance_animate_to_position, ":instance_no", 1, 70), #animate to position 1 in 0.7 second
        (val_add, "$tutorial_num_total_dummies_destroyed", 1),
        (play_sound, "snd_dummy_destroyed"),
    ]),
   (ti_on_scene_prop_hit,
    [
        (store_trigger_param_1, ":instance_no"),
        (store_trigger_param_2, ":damage"),
        (assign, reg60, ":damage"),
        (val_div, ":damage", 8),
        (prop_instance_get_position, pos2, ":instance_no"),
        (get_player_agent_no, ":player_agent"),
        (agent_get_position, pos3, ":player_agent"),
        (try_begin),
          (position_is_behind_position, pos3, pos2),
          (val_mul, ":damage", -1),
        (try_end),
        (position_rotate_x, 2, ":damage"),
        (display_message, "str_delivered_damage"),
        (prop_instance_animate_to_position, ":instance_no", 2, 30), #animate to position 1 in 0.3 second
        (play_sound, "snd_dummy_hit"),
        (particle_system_burst, "psys_dummy_smoke", pos1, 3),
        (particle_system_burst, "psys_dummy_straw", pos1, 10),
    ]),
  ]),

  ("band_a",0,"band_a","0", []),
  ("arena_sign",0,"arena_arms","0", []),

  ("castle_h_battlement_a",0,"castle_h_battlement_a","bo_castle_h_battlement_a", []),
  ("castle_h_battlement_b",0,"castle_h_battlement_b","bo_castle_h_battlement_b", []),
  ("castle_h_battlement_c",0,"castle_h_battlement_c","bo_castle_h_battlement_c", []),
  ("castle_h_battlement_a2",0,"castle_h_battlement_a2","bo_castle_h_battlement_a2", []),
  ("castle_h_battlement_b2",0,"castle_h_battlement_b2","bo_castle_h_battlement_b2", []),
  ("castle_h_corner_a",0,"castle_h_corner_a","bo_castle_h_corner_a", []),
  ("castle_h_corner_c",0,"castle_h_corner_c","bo_castle_h_corner_c", []),
  ("castle_h_stairs_a",sokf_type_ladder,"castle_h_stairs_a","bo_castle_h_stairs_a", []),
  ("castle_h_stairs_b",0,"castle_h_stairs_b","bo_castle_h_stairs_b", []),
  ("castle_h_gatehouse_a",0,"castle_h_gatehouse_a","bo_castle_h_gatehouse_a", []),
  ("castle_h_keep_a",0,"castle_h_keep_a","bo_castle_h_keep_a", []),
  ("castle_h_keep_b",0,"castle_h_keep_b","bo_castle_h_keep_b", []),
  ("castle_h_house_a",0,"castle_h_house_a","bo_castle_h_house_a", []),
  ("castle_h_house_b",0,"castle_h_house_b","bo_castle_h_house_b", []),
  ("castle_h_house_c",0,"castle_h_house_c","bo_castle_h_house_b", []),
  ("castle_h_battlement_barrier",0,"castle_h_battlement_barrier","bo_castle_h_battlement_barrier", []),




  ("full_keep_b",sokf_type_ladder,"full_keep_b","bo_full_keep_b", []),

  ("castle_f_keep_a",0,"castle_f_keep_a","bo_castle_f_keep_a", []),
  ("castle_f_battlement_a",0,"castle_f_battlement_a","bo_castle_f_battlement_a", []),
  ("castle_f_battlement_a_destroyed",0,"castle_f_battlement_a_destroyed","bo_castle_f_battlement_a_destroyed", []),
  ("castle_f_battlement_b",0,"castle_f_battlement_b","bo_castle_f_battlement_b", []),
  ("castle_f_battlement_c",0,"castle_f_battlement_c","bo_castle_f_battlement_c", []),
  ("castle_f_battlement_d",0,"castle_f_battlement_d","bo_castle_f_battlement_d", []),
  ("castle_f_battlement_e",0,"castle_f_battlement_e","bo_castle_f_battlement_e", []),
  ("castle_f_sally_port_elevation",0,"castle_f_sally_port_elevation","bo_castle_f_sally_port_elevation", []),
  ("castle_f_battlement_corner_a",0,"castle_f_battlement_corner_a","bo_castle_f_battlement_corner_a", []),
  ("castle_f_battlement_corner_b",0,"castle_f_battlement_corner_b","bo_castle_f_battlement_corner_b", []),
  ("castle_f_battlement_corner_c",0,"castle_f_battlement_corner_c","bo_castle_f_battlement_corner_c", []),
  
  ("castle_f_door_a",sokf_moveable|sokf_show_hit_point_bar|sokf_destructible|spr_use_time(0),"castle_f_door_a","bo_castle_f_door_a", [
    check_castle_door_use_trigger,

   (ti_on_init_scene_prop,
    [
      (store_trigger_param_1, ":instance_no"),
      (scene_prop_set_hit_points, ":instance_no", 1000),
    ]),
     
   (ti_on_scene_prop_destroy,
    [
      (play_sound, "snd_dummy_destroyed"),
      
      (assign, ":rotate_side", 86),
      
      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),

        (store_trigger_param_1, ":instance_no"),      
        (store_trigger_param_2, ":attacker_agent_no"),

        (set_fixed_point_multiplier, 100),
        (prop_instance_get_position, pos1, ":instance_no"),

        (try_begin),
          (ge, ":attacker_agent_no", 0),
          (agent_get_position, pos2, ":attacker_agent_no"),
          (try_begin),
            (position_is_behind_position, pos2, pos1),
            (val_mul, ":rotate_side", -1),
          (try_end),
        (try_end),
      
        (init_position, pos3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (position_move_y, pos3, -100),
        (else_try),
          (position_move_y, pos3, 100),
        (try_end),
      
        (position_move_x, pos3, -50),
        (position_transform_position_to_parent, pos4, pos1, pos3),
        (position_move_z, pos4, 100),
        (position_get_distance_to_ground_level, ":height_to_terrain", pos4),
        (val_sub, ":height_to_terrain", 100),
        (assign, ":z_difference", ":height_to_terrain"),
        #(assign, reg0, ":z_difference"),
        #(display_message, "@{!}z dif : {reg0}"),
        (val_div, ":z_difference", 3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (val_add, ":rotate_side", ":z_difference"),
        (else_try),
          (val_sub, ":rotate_side", ":z_difference"),
        (try_end),

        (position_rotate_x, pos1, ":rotate_side"),
        (prop_instance_animate_to_position, ":instance_no", pos1, 70), #animate to position 1 in 0.7 second
      (try_end),
    ]),       
  
    (ti_on_scene_prop_hit,
    [
      (store_trigger_param_1, ":instance_no"),       
      (store_trigger_param_2, ":damage"),
      
      (try_begin),
        (scene_prop_get_hit_points, ":hit_points", ":instance_no"),
        (val_sub, ":hit_points", ":damage"),
        (gt, ":hit_points", 0),
        (play_sound, "snd_dummy_hit"),
      (else_try),
        (neg|multiplayer_is_server),
        (play_sound, "snd_dummy_destroyed"),
      (try_end),

      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),

        (particle_system_burst, "psys_dummy_smoke", pos1, 3),
        (particle_system_burst, "psys_dummy_straw", pos1, 10),
      (try_end),      
    ]),
  ]),

  ("castle_f_doors_top_a",0,"castle_f_doors_top_a","bo_castle_f_doors_top_a", []),
    
  ("castle_f_sally_door_a",sokf_moveable|sokf_show_hit_point_bar|sokf_destructible|spr_use_time(0),"castle_f_sally_door_a","bo_castle_f_sally_door_a", [
    check_sally_door_use_trigger,

   (ti_on_init_scene_prop,
    [
      (store_trigger_param_1, ":instance_no"),
      (scene_prop_set_hit_points, ":instance_no", 1000),
    ]),
     
   (ti_on_scene_prop_destroy,
    [
      (play_sound, "snd_dummy_destroyed"),
      
      (assign, ":rotate_side", 86),
      
      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),

        (store_trigger_param_1, ":instance_no"),      
        (store_trigger_param_2, ":attacker_agent_no"),

        (set_fixed_point_multiplier, 100),
        (prop_instance_get_position, pos1, ":instance_no"),

        (try_begin),
          (ge, ":attacker_agent_no", 0),
          (agent_get_position, pos2, ":attacker_agent_no"),
          (try_begin),
            (position_is_behind_position, pos2, pos1),
            (val_mul, ":rotate_side", -1),
          (try_end),
        (try_end),
      
        (init_position, pos3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (position_move_y, pos3, -100),
        (else_try),
          (position_move_y, pos3, 100),
        (try_end),
      
        (position_move_x, pos3, -50),
        (position_transform_position_to_parent, pos4, pos1, pos3),
        (position_move_z, pos4, 100),
        (position_get_distance_to_ground_level, ":height_to_terrain", pos4),
        (val_sub, ":height_to_terrain", 100),
        (assign, ":z_difference", ":height_to_terrain"),
        (val_div, ":z_difference", 3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (val_add, ":rotate_side", ":z_difference"),
        (else_try),
          (val_sub, ":rotate_side", ":z_difference"),
        (try_end),

        (position_rotate_x, pos1, ":rotate_side"),
        (prop_instance_animate_to_position, ":instance_no", pos1, 70), #animate to position 1 in 0.7 second
      (try_end),
    ]),       

    (ti_on_scene_prop_hit,
    [
      (store_trigger_param_1, ":instance_no"),       
      (store_trigger_param_2, ":damage"),
      
      (try_begin),
        (scene_prop_get_hit_points, ":hit_points", ":instance_no"),
        (val_sub, ":hit_points", ":damage"),
        (gt, ":hit_points", 0),
        (play_sound, "snd_dummy_hit"),
      (else_try),
        (neg|multiplayer_is_server),
        (play_sound, "snd_dummy_destroyed"),
      (try_end),

      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),

        (particle_system_burst, "psys_dummy_smoke", pos1, 3),
        (particle_system_burst, "psys_dummy_straw", pos1, 10),
      (try_end),      
    ]),
  ]),

  ("castle_f_stairs_a",sokf_type_ladder,"castle_f_stairs_a","bo_castle_f_stairs_a", []),
  ("castle_f_tower_a",sokf_type_ladder,"castle_f_tower_a","bo_castle_f_tower_a", []),
  ("castle_f_wall_stairs_a",sokf_type_ladder,"castle_f_wall_stairs_a","bo_castle_f_wall_stairs_a", []),
  ("castle_f_wall_stairs_b",sokf_type_ladder,"castle_f_wall_stairs_b","bo_castle_f_wall_stairs_b", []),
  ("castle_f_wall_way_a",0,"castle_f_wall_way_a","bo_castle_f_wall_way_a", []),
  ("castle_f_wall_way_b",0,"castle_f_wall_way_b","bo_castle_f_wall_way_b", []),
  ("castle_f_gatehouse_a",0,"castle_f_gatehouse_a","bo_castle_f_gatehouse_a", []),

  ("castle_g_battlement_a",0,"castle_g_battlement_a","bo_castle_g_battlement_a", []),
  ("castle_g_battlement_a1",0,"castle_g_battlement_a1","bo_castle_g_battlement_a1", []),
  ("castle_g_battlement_c",0,"castle_g_battlement_c","bo_castle_g_battlement_c", []),
  ("castle_g_corner_a",0,"castle_g_corner_a","bo_castle_g_corner_a", []),
  ("castle_g_corner_c",0,"castle_g_corner_c","bo_castle_g_corner_c", []),  
  ("castle_g_tower_a",sokf_type_ladder,"castle_g_tower_a","bo_castle_g_tower_a", []),
  ("castle_g_gate_house",0,"castle_g_gate_house","bo_castle_g_gate_house", []),
  ("castle_g_gate_house_door_a",0,"castle_g_gate_house_door_a","bo_castle_g_gate_house_door_a", []),
  ("castle_g_gate_house_door_b",0,"castle_g_gate_house_door_b","bo_castle_g_gate_house_door_b", []),
  ("castle_g_square_keep_a",0,"castle_g_square_keep_a","bo_castle_g_square_keep_a", []),

  ("castle_i_battlement_a",0,"castle_i_battlement_a","bo_castle_i_battlement_a", []),
  ("castle_i_battlement_a1",0,"castle_i_battlement_a1","bo_castle_i_battlement_a1", []),
  ("castle_i_battlement_c",0,"castle_i_battlement_c","bo_castle_i_battlement_c", []),
  ("castle_i_corner_a",0,"castle_i_corner_a","bo_castle_i_corner_a", []),
  ("castle_i_corner_c",0,"castle_i_corner_c","bo_castle_i_corner_c", []),  
  ("castle_i_tower_a",sokf_type_ladder,"castle_i_tower_a","bo_castle_i_tower_a", []),
  ("castle_i_gate_house",0,"castle_i_gate_house","bo_castle_i_gate_house", []),
  ("castle_i_gate_house_door_a",0,"castle_i_gate_house_door_a","bo_castle_i_gate_house_door_a", []),
  ("castle_i_gate_house_door_b",0,"castle_i_gate_house_door_b","bo_castle_i_gate_house_door_b", []),
  ("castle_i_square_keep_a",0,"castle_i_square_keep_a","bo_castle_i_square_keep_a", []),





  ("mosque_a",0,"mosque_a","bo_mosque_a", []),
  ("stone_minaret_a",0,"stone_minaret_a","bo_stone_minaret_a", []),
  ("stone_house_a",0,"stone_house_a","bo_stone_house_a", []),
  ("stone_house_b",0,"stone_house_b","bo_stone_house_b", []),
  ("stone_house_c",0,"stone_house_c","bo_stone_house_c", []),
  ("stone_house_d",0,"stone_house_d","bo_stone_house_d", []),
  ("stone_house_e",0,"stone_house_e","bo_stone_house_e", []),
  ("stone_house_f",0,"stone_house_f","bo_stone_house_f", []),

  ("banner_pole", sokf_moveable, "banner_pole", "bo_banner_pole", []),

  ("custom_banner_01",0,"custom_banner_01","0",
   [
     (ti_on_init_scene_prop,
      [
        (party_get_slot, ":leader_troop", "$g_encountered_party", slot_town_lord),
        (try_begin),
          (ge, ":leader_troop", 0),
          (cur_scene_prop_set_tableau_material, "tableau_custom_banner_default", ":leader_troop"),
        (try_end),
        ]),
     ]),
  ("custom_banner_02",0,"custom_banner_02","0",
   [
     (ti_on_init_scene_prop,
      [
        (party_get_slot, ":leader_troop", "$g_encountered_party", slot_town_lord),
        (try_begin),
          (ge, ":leader_troop", 0),
          (cur_scene_prop_set_tableau_material, "tableau_custom_banner_default", ":leader_troop"),
        (try_end),
        ]),
     ]),

  ("banner_a",0,"banner_a01","0", []),
  ("banner_b",0,"banner_a02","0", []),
  ("banner_c",0,"banner_a03","0", []),
  ("banner_d",0,"banner_a04","0", []),
  ("banner_e",0,"banner_a05","0", []),
  ("banner_f",0,"banner_a06","0", []),
  ("banner_g",0,"banner_a07","0", []),
  ("banner_h",0,"banner_a08","0", []),
  ("banner_i",0,"banner_a09","0", []),
  ("banner_j",0,"banner_a10","0", []),
  ("banner_k",0,"banner_a11","0", []),
  ("banner_l",0,"banner_a12","0", []),
  ("banner_m",0,"banner_a13","0", []),
  ("banner_n",0,"banner_a14","0", []),
  ("banner_o",0,"banner_f21","0", []),
  ("banner_p",0,"banner_a16","0", []),
  ("banner_q",0,"banner_a17","0", []),
  ("banner_r",0,"banner_a18","0", []),
  ("banner_s",0,"banner_a19","0", []),
  ("banner_t",0,"banner_a20","0", []),
  ("banner_u",0,"banner_a21","0", []),
  ("banner_ba",0,"banner_b01","0", []),
  ("banner_bb",0,"banner_b02","0", []),
  ("banner_bc",0,"banner_b03","0", []),
  ("banner_bd",0,"banner_b04","0", []),
  ("banner_be",0,"banner_b05","0", []),
  ("banner_bf",0,"banner_b06","0", []),
  ("banner_bg",0,"banner_b07","0", []),
  ("banner_bh",0,"banner_b08","0", []),
  ("banner_bi",0,"banner_b09","0", []),
  ("banner_bj",0,"banner_b10","0", []),
  ("banner_bk",0,"banner_b11","0", []),
  ("banner_bl",0,"banner_b12","0", []),
  ("banner_bm",0,"banner_b13","0", []),
  ("banner_bn",0,"banner_b14","0", []),
  ("banner_bo",0,"banner_b15","0", []),
  ("banner_bp",0,"banner_b16","0", []),
  ("banner_bq",0,"banner_b17","0", []),
  ("banner_br",0,"banner_b18","0", []),
  ("banner_bs",0,"banner_b19","0", []),
  ("banner_bt",0,"banner_b20","0", []),
  ("banner_bu",0,"banner_b21","0", []),
  ("banner_ca",0,"banner_c01","0", []),
  ("banner_cb",0,"banner_c02","0", []),
  ("banner_cc",0,"banner_c03","0", []),
  ("banner_cd",0,"banner_c04","0", []),
  ("banner_ce",0,"banner_c05","0", []),
  ("banner_cf",0,"banner_c06","0", []),
  ("banner_cg",0,"banner_c07","0", []),
  ("banner_ch",0,"banner_c08","0", []),
  ("banner_ci",0,"banner_c09","0", []),
  ("banner_cj",0,"banner_c10","0", []),
  ("banner_ck",0,"banner_c11","0", []),
  ("banner_cl",0,"banner_c12","0", []),
  ("banner_cm",0,"banner_c13","0", []),
  ("banner_cn",0,"banner_c14","0", []),
  ("banner_co",0,"banner_c15","0", []),
  ("banner_cp",0,"banner_c16","0", []),
  ("banner_cq",0,"banner_c17","0", []),
  ("banner_cr",0,"banner_c18","0", []),
  ("banner_cs",0,"banner_c19","0", []),
  ("banner_ct",0,"banner_c20","0", []),
  ("banner_cu",0,"banner_c21","0", []),
  ("banner_da",0,"banner_d01","0", []),
  ("banner_db",0,"banner_d02","0", []),
  ("banner_dc",0,"banner_d03","0", []),
  ("banner_dd",0,"banner_d04","0", []),
  ("banner_de",0,"banner_d05","0", []),
  ("banner_df",0,"banner_d06","0", []),
  ("banner_dg",0,"banner_d07","0", []),
  ("banner_dh",0,"banner_d08","0", []),
  ("banner_di",0,"banner_d09","0", []),
  ("banner_dj",0,"banner_d10","0", []),
  ("banner_dk",0,"banner_d11","0", []),
  ("banner_dl",0,"banner_d12","0", []),
  ("banner_dm",0,"banner_d13","0", []),
  ("banner_dn",0,"banner_d14","0", []),
  ("banner_do",0,"banner_d15","0", []),
  ("banner_dp",0,"banner_d16","0", []),
  ("banner_dq",0,"banner_d17","0", []),
  ("banner_dr",0,"banner_d18","0", []),
  ("banner_ds",0,"banner_d19","0", []),
  ("banner_dt",0,"banner_d20","0", []),
  ("banner_du",0,"banner_d21","0", []),
  ("banner_ea",0,"banner_e01","0", []),
  ("banner_eb",0,"banner_e02","0", []),
  ("banner_ec",0,"banner_e03","0", []),
  ("banner_ed",0,"banner_e04","0", []),
  ("banner_ee",0,"banner_e05","0", []),
  ("banner_ef",0,"banner_e06","0", []),
  ("banner_eg",0,"banner_e07","0", []),
  ("banner_eh",0,"banner_e08","0", []),
  ("banner_ei",0,"banner_e09","0", []),
  ("banner_ej",0,"banner_e10","0", []),
  ("banner_ek",0,"banner_e11","0", []),
  ("banner_el",0,"banner_e12","0", []),
  ("banner_em",0,"banner_e13","0", []),
  ("banner_en",0,"banner_e14","0", []),
  ("banner_eo",0,"banner_e15","0", []),
  ("banner_ep",0,"banner_e16","0", []),
  ("banner_eq",0,"banner_e17","0", []),
  ("banner_er",0,"banner_e18","0", []),
  ("banner_es",0,"banner_e19","0", []),
  ("banner_et",0,"banner_e20","0", []),
  ("banner_eu",0,"banner_e21","0", []),

  ("banner_f01", 0, "banner_f01", "0", []),
  ("banner_f02", 0, "banner_f02", "0", []),
  ("banner_f03", 0, "banner_f03", "0", []),
  ("banner_f04", 0, "banner_f04", "0", []),
  ("banner_f05", 0, "banner_f05", "0", []),
  ("banner_f06", 0, "banner_f06", "0", []),
  ("banner_f07", 0, "banner_f07", "0", []),
  ("banner_f08", 0, "banner_f08", "0", []),
  ("banner_f09", 0, "banner_f09", "0", []),
  ("banner_f10", 0, "banner_f10", "0", []),
  ("banner_f11", 0, "banner_f11", "0", []),
  ("banner_f12", 0, "banner_f12", "0", []),
  ("banner_f13", 0, "banner_f13", "0", []),
  ("banner_f14", 0, "banner_f14", "0", []),
  ("banner_f15", 0, "banner_f15", "0", []),
  ("banner_f16", 0, "banner_f16", "0", []),
  ("banner_f17", 0, "banner_f17", "0", []),
  ("banner_f18", 0, "banner_f18", "0", []),
  ("banner_f19", 0, "banner_f19", "0", []),
  ("banner_f20", 0, "banner_f20", "0", []),
 
  ("banner_g01", 0, "banner_f01", "0", []),
  ("banner_g02", 0, "banner_f02", "0", []),
  ("banner_g03", 0, "banner_f03", "0", []),
  ("banner_g04", 0, "banner_f04", "0", []),
  ("banner_g05", 0, "banner_f05", "0", []),
  ("banner_g06", 0, "banner_f06", "0", []),
  ("banner_g07", 0, "banner_f07", "0", []),
  ("banner_g08", 0, "banner_f08", "0", []),
  ("banner_g09", 0, "banner_f09", "0", []),
  ("banner_g10", 0, "banner_f10", "0", []),

  ("banner_kingdom_a", 0, "banner_kingdom_a", "0", []),
  ("banner_kingdom_b", 0, "banner_kingdom_b", "0", []),
  ("banner_kingdom_c", 0, "banner_kingdom_c", "0", []),
  ("banner_kingdom_d", 0, "banner_kingdom_d", "0", []),
  ("banner_kingdom_e", 0, "banner_kingdom_e", "0", []),
  ("banner_kingdom_f", 0, "banner_kingdom_f", "0", []),
  ("banner_f21", 0, "banner_a15", "0", []),

  ("tavern_chair_a",0,"tavern_chair_a","bo_tavern_chair_a", []),
  ("tavern_chair_b",0,"tavern_chair_b","bo_tavern_chair_b", []),
  ("tavern_table_a",0,"tavern_table_a","bo_tavern_table_a", []),
  ("tavern_table_b",0,"tavern_table_b","bo_tavern_table_b", []),
  ("fireplace_a",0,"fireplace_a","bo_fireplace_a", []),
  ("barrel",0,"barrel","bobarrel", []),
  ("bench_tavern",0,"bench_tavern","bobench_tavern", []),
  ("bench_tavern_b",0,"bench_tavern_b","bo_bench_tavern_b", []),
  ("bowl_wood",0,"bowl_wood","0", []),
  ("chandelier_table",0,"chandelier_table","0", []),
  ("chandelier_tavern",0,"chandelier_tavern","0", []),
  ("chest_gothic",0,"chest_gothic","bochest_gothic", []),
  ("chest_b",0,"chest_b","bo_chest_b", []),
  ("chest_c",0,"chest_c","bo_chest_c", []),
  ("counter_tavern",0,"counter_tavern","bocounter_tavern", []),
  ("cup",0,"cup","0", []),
  ("dish_metal",0,"dish_metal","0", []),
  ("gothic_chair",0,"gothic_chair","bogothic_chair", []),
  ("gothic_stool",0,"gothic_stool","bogothic_stool", []),
  ("grate",0,"grate","bograte", []),
  ("jug",0,"jug","0", []),
  ("potlamp",0,"potlamp","0", []),
  ("weapon_rack",0,"weapon_rack","boweapon_rack", []),
  ("weapon_rack_big",0,"weapon_rack_big","boweapon_rack_big", []),
  ("tavern_barrel",0,"barrel","bobarrel", []),
  ("tavern_barrel_b",0,"tavern_barrel_b","bo_tavern_barrel_b", []),
  ("merchant_sign",0,"merchant_sign","bo_tavern_sign", []),
  ("tavern_sign",0,"tavern_sign","bo_tavern_sign", []),
  ("sack",0,"sack","0", []),
  ("skull_a",0,"skull_a","0", []),
  ("skull_b",0,"skull_b","0", []),
  ("skull_c",0,"skull_c","0", []),
  ("skull_d",0,"skull_d","0", []),
  ("skeleton_cow",0,"skeleton_cow","0", []),
  ("cupboard_a",0,"cupboard_a","bo_cupboard_a", []),
  ("box_a",0,"box_a","bo_box_a", []),
  ("bucket_a",0,"bucket_a","bo_bucket_a", []),
  ("straw_a",0,"straw_a","0", []),
  ("straw_b",0,"straw_b","0", []),
  ("straw_c",0,"straw_c","0", []),
  ("cloth_a",0,"cloth_a","0", []),
  ("cloth_b",0,"cloth_b","0", []),
  ("mat_a",0,"mat_a","0", []),
  ("mat_b",0,"mat_b","0", []),
  ("mat_c",0,"mat_c","0", []),
  ("mat_d",0,"mat_d","0", []),

  ("wood_a",0,"wood_a","bo_wood_a", []),
  ("wood_b",0,"wood_b","bo_wood_b", []),
  ("wood_heap",0,"wood_heap_a","bo_wood_heap_a", []),
  ("wood_heap_b",0,"wood_heap_b","bo_wood_heap_b", []),
  
  ("water_well_a",0,"water_well_a","bo_water_well_a", []),
  ("water_well_b",0,"water_well_b","bo_water_well_b", []),
#  ("water_well_a_old",0,"water_well_a_old","bo_water_well_a_old", []),  
  ("net_a",0,"net_a","bo_net_a", []),
  ("net_b",0,"net_b","0", []),

  ("meat_hook",0,"meat_hook","0", []),
  ("cooking_pole",0,"cooking_pole","0", []),
  ("bowl_a",0,"bowl_a","0", []),
  ("bucket_b",0,"bucket_b","0", []),
  ("washtub_a",0,"washtub_a","bo_washtub_a", []),
  ("washtub_b",0,"washtub_b","bo_washtub_b", []),

  ("table_trunk_a",0,"table_trunk_a","bo_table_trunk_a", []),
  ("chair_trunk_a",0,"chair_trunk_a","bo_chair_trunk_a", []),
  ("chair_trunk_b",0,"chair_trunk_b","bo_chair_trunk_b", []),
  ("chair_trunk_c",0,"chair_trunk_c","bo_chair_trunk_c", []),

  ("table_trestle_long",0,"table_trestle_long","bo_table_trestle_long", []),
  ("table_trestle_small",0,"table_trestle_small","bo_table_trestle_small", []),
  ("chair_trestle",0,"chair_trestle","bo_chair_trestle", []),

  ("wheel",0,"wheel","bo_wheel", []),
  ("ladder",sokf_type_ladder,"ladder","boladder", []),
  ("cart",0,"cart","bo_cart", []),
  ("village_stand",0,"village_stand","bovillage_stand", []),
  ("wooden_stand",0,"wooden_stand","bowooden_stand", []),
  ("table_small",0,"table_small","bo_table_small", []),
  ("table_small_b",0,"table_small_b","bo_table_small_b", []),
  ("small_timber_frame_house_a",0,"small_timber_frame_house_a","bo_small_timber_frame_house_a", []),
  ("timber_frame_house_b",0,"tf_house_b","bo_tf_house_b", []),
  ("timber_frame_house_c",0,"tf_house_c","bo_tf_house_c", []),
  ("timber_frame_extension_a",0,"timber_frame_extension_a","bo_timber_frame_extension_a", []),
  ("timber_frame_extension_b",0,"timber_frame_extension_b","bo_timber_frame_extension_b", []),
  ("stone_stairs_a",sokf_type_ladder,"stone_stairs_a","bo_stone_stairs_a", []),
  ("stone_stairs_b",sokf_type_ladder,"stone_stairs_b","bo_stone_stairs_b", []),
  ("railing_a",0,"railing_a","bo_railing_a", []),
  ("side_building_a",0,"side_building_a","bo_side_building_a", []),
  ("battlement_a",0,"battlement_a","bo_battlement_a", []),

  ("battlement_a_destroyed",0,"battlement_a_destroyed","bo_battlement_a_destroyed", []),


  ("round_tower_a",0,"round_tower_a","bo_round_tower_a", []),
  ("small_round_tower_a",0,"small_round_tower_a","bo_small_round_tower_a", []),
  ("small_round_tower_roof_a",0,"small_round_tower_roof_a","bo_small_round_tower_roof_a", []),
  ("square_keep_a",0,"square_keep_a","bo_square_keep_a", []),
  ("square_tower_roof_a",0,"square_tower_roof_a","0", []),
  ("gate_house_a",0,"gate_house_a","bo_gate_house_a", []),
  ("gate_house_b",0,"gate_house_b","bo_gate_house_b", []),
  ("small_wall_a",0,"small_wall_a","bo_small_wall_a", []),
  ("small_wall_b",0,"small_wall_b","bo_small_wall_b", []),
  ("small_wall_c",0,"small_wall_c","bo_small_wall_c", []),
  ("small_wall_c_destroy",0,"small_wall_c_destroy","bo_small_wall_c_destroy", []),
  ("small_wall_d",0,"small_wall_d","bo_small_wall_d", []),
  ("small_wall_e",0,"small_wall_e","bo_small_wall_d", []),
  ("small_wall_f",0,"small_wall_f","bo_small_wall_f", []),
  ("small_wall_f2",0,"small_wall_f2","bo_small_wall_f2", []),


  ("town_house_a",0,"town_house_a","bo_town_house_a", []),
  ("town_house_b",0,"town_house_b","bo_town_house_b", []),
  ("town_house_c",0,"town_house_c","bo_town_house_c", []),
  ("town_house_d",0,"town_house_d","bo_town_house_d", []),
  ("town_house_e",0,"town_house_e","bo_town_house_e", []),
  ("town_house_f",0,"town_house_f","bo_town_house_f", []),
  ("town_house_g",0,"town_house_g","bo_town_house_g", []),
  ("town_house_h",0,"town_house_h","bo_town_house_h", []),
  ("town_house_i",0,"town_house_i","bo_town_house_i", []),
  ("town_house_j",0,"town_house_j","bo_town_house_j", []),
  ("town_house_l",0,"town_house_l","bo_town_house_l", []),

  ("town_house_m",0,"town_house_m","bo_town_house_m", []),
  ("town_house_n",0,"town_house_n","bo_town_house_n", []),
  ("town_house_o",0,"town_house_o","bo_town_house_o", []),
  ("town_house_p",0,"town_house_p","bo_town_house_p", []),
  ("town_house_q",0,"town_house_q","bo_town_house_q", []),
  
  ("passage_house_a",0,"passage_house_a","bo_passage_house_a", []),
  ("passage_house_b",0,"passage_house_b","bo_passage_house_b", []),
  ("passage_house_c",0,"passage_house_c","bo_passage_house_c", []),
  ("passage_house_d",0,"passage_house_d","bo_passage_house_d", []),
  ("passage_house_c_door",0,"passage_house_c_door","bo_passage_house_c_door", []),

  ("house_extension_a",0,"house_extension_a","bo_house_extension_a", []),
  ("house_extension_b",0,"house_extension_b","bo_house_extension_b", []),
  ("house_extension_c",0,"house_extension_c","bo_house_extension_a", []),#reuse 
  ("house_extension_d",0,"house_extension_d","bo_house_extension_d", []),

  ("house_extension_e",0,"house_extension_e","bo_house_extension_e", []),
  ("house_extension_f",0,"house_extension_f","bo_house_extension_f", []),
  ("house_extension_f2",0,"house_extension_f2","bo_house_extension_f", []),
  ("house_extension_g",0,"house_extension_g","bo_house_extension_g", []),
  ("house_extension_g2",0,"house_extension_g2","bo_house_extension_g", []),
  ("house_extension_h",0,"house_extension_h","bo_house_extension_h", []),
  ("house_extension_i",0,"house_extension_i","bo_house_extension_i", []),

  ("house_roof_door",0,"house_roof_door","bo_house_roof_door", []),


  ("door_extension_a",0,"door_extension_a","bo_door_extension_a", []),
  ("stairs_arch_a",sokf_type_ladder,"stairs_arch_a","bo_stairs_arch_a", []),

  ("town_house_r",0,"town_house_r","bo_town_house_r", []),
  ("town_house_s",0,"town_house_s","bo_town_house_s", []),
  ("town_house_t",0,"town_house_t","bo_town_house_t", []),
  ("town_house_u",0,"town_house_u","bo_town_house_u", []),
  ("town_house_v",0,"town_house_v","bo_town_house_v", []),
  ("town_house_w",0,"town_house_w","bo_town_house_w", []),

  ("town_house_y",0,"town_house_y","bo_town_house_y", []),
  ("town_house_z",0,"town_house_z","bo_town_house_z", []),
  ("town_house_za",0,"town_house_za","bo_town_house_za", []),
  
  ("windmill",0,"windmill","bo_windmill", []),
  ("windmill_fan_turning",sokf_moveable,"windmill_fan_turning","bo_windmill_fan_turning", []),
  ("windmill_fan",0,"windmill_fan","bo_windmill_fan", []),
  ("fake_house_a",0,"fake_house_a","bo_fake_house_a", []),
  ("fake_house_b",0,"fake_house_b","bo_fake_house_b", []),
  ("fake_house_c",0,"fake_house_c","bo_fake_house_c", []),
  ("fake_house_d",0,"fake_house_d","bo_fake_house_d", []),
  ("fake_house_e",0,"fake_house_e","bo_fake_house_e", []),
  ("fake_house_f",0,"fake_house_f","bo_fake_house_f", []),

  ("fake_house_snowy_a",0,"fake_house_snowy_a","bo_fake_house_a", []),
  ("fake_house_snowy_b",0,"fake_house_snowy_b","bo_fake_house_b", []),
  ("fake_house_snowy_c",0,"fake_house_snowy_c","bo_fake_house_c", []),
  ("fake_house_snowy_d",0,"fake_house_snowy_d","bo_fake_house_d", []),


  ("fake_house_far_a",0,"fake_house_far_a","0", []),
  ("fake_house_far_b",0,"fake_house_far_b","0", []),
  ("fake_house_far_c",0,"fake_house_far_c","0", []),
  ("fake_house_far_d",0,"fake_house_far_d","0", []),
  ("fake_house_far_e",0,"fake_house_far_e","0", []),
  ("fake_house_far_f",0,"fake_house_far_f","0", []),

  ("fake_house_far_snowycrude_a",0,"fake_house_far_snowy_a","0", []),
  ("fake_house_far_snowy_b",0,"fake_house_far_snowy_b","0", []),
  ("fake_house_far_snowy_c",0,"fake_house_far_snowy_c","0", []),
  ("fake_house_far_snowy_d",0,"fake_house_far_snowy_d","0", []),

  ("earth_wall_a",0,"earth_wall_a","bo_earth_wall_a", []),
  ("earth_wall_a2",0,"earth_wall_a2","bo_earth_wall_a2", []),
  ("earth_wall_b",0,"earth_wall_b","bo_earth_wall_b", []),
  ("earth_wall_b2",0,"earth_wall_b2","bo_earth_wall_b2", []),
  ("earth_stairs_a",sokf_type_ladder,"earth_stairs_a","bo_earth_stairs_a", []),
  ("earth_stairs_b",sokf_type_ladder,"earth_stairs_b","bo_earth_stairs_b", []),
  ("earth_tower_small_a",0,"earth_tower_small_a","bo_earth_tower_small_a", []),
  ("earth_gate_house_a",0,"earth_gate_house_a","bo_earth_gate_house_a", []),
  ("earth_gate_a",0,"earth_gate_a","bo_earth_gate_a", []),
  ("earth_square_keep_a",0,"earth_square_keep_a","bo_earth_square_keep_a", []),
  ("earth_house_a",0,"earth_house_a","bo_earth_house_a", []),
  ("earth_house_b",0,"earth_house_b","bo_earth_house_b", []),
  ("earth_house_c",0,"earth_house_c","bo_earth_house_c", []),
  ("earth_house_d",0,"earth_house_d","bo_earth_house_d", []),

  ("village_steppe_a",0,"village_steppe_a","bo_village_steppe_a", []),
  ("village_steppe_b",0,"village_steppe_b","bo_village_steppe_b", []),
  ("village_steppe_c",0,"village_steppe_c","bo_village_steppe_c", []),
  ("village_steppe_d",0,"village_steppe_d","bo_village_steppe_d", []),
  ("village_steppe_e",0,"village_steppe_e","bo_village_steppe_e", []),
  ("village_steppe_f",0,"village_steppe_f","bo_village_steppe_f", []),
  ("town_house_aa",0,"town_house_aa","bo_town_house_aa", []),
  
  
  ("snowy_house_a",0,"snowy_house_a","bo_snowy_house_a", []),
  ("snowy_house_b",0,"snowy_house_b","bo_snowy_house_b", []),
  ("snowy_house_c",0,"snowy_house_c","bo_snowy_house_c", []),
  ("snowy_house_d",0,"snowy_house_d","bo_snowy_house_d", []),
  ("snowy_house_e",0,"snowy_house_e","bo_snowy_house_e", []),
  ("snowy_house_f",0,"snowy_house_f","bo_snowy_house_f", []),
  ("snowy_house_g",0,"snowy_house_g","bo_snowy_house_g", []),
  ("snowy_house_h",0,"snowy_house_h","bo_snowy_house_h", []),
  ("snowy_house_i",0,"snowy_house_i","bo_snowy_house_i", []),
  ("snowy_wall_a",0,"snowy_wall_a","bo_snowy_wall_a", []),

  ("snowy_stand",0,"snowy_stand","bo_snowy_stand", []),

  ("snowy_heap_a",0,"snowy_heap_a","bo_snowy_heap_a", []),
  ("snowy_trunks_a",0,"snowy_trunks_a","bo_snowy_trunks_a", []),

  ("snowy_castle_tower_a",0,"snowy_castle_tower_a","bo_snowy_castle_tower_a", []),
  ("snowy_castle_battlement_a",0,"snowy_castle_battlement_a","bo_snowy_castle_battlement_a", []),
  ("snowy_castle_battlement_a_destroyed",0,"snowy_castle_battlement_a_destroyed","bo_snowy_castle_battlement_a_destroyed", []),
 
  ("snowy_castle_battlement_b",0,"snowy_castle_battlement_b","bo_snowy_castle_battlement_b", []),
  ("snowy_castle_battlement_corner_a",0,"snowy_castle_battlement_corner_a","bo_snowy_castle_battlement_corner_a", []),
  ("snowy_castle_battlement_corner_b",0,"snowy_castle_battlement_corner_b","bo_snowy_castle_battlement_corner_b", []),
  ("snowy_castle_battlement_corner_c",0,"snowy_castle_battlement_corner_c","bo_snowy_castle_battlement_corner_c", []),
  ("snowy_castle_battlement_stairs_a",0,"snowy_castle_battlement_stairs_a","bo_snowy_castle_battlement_stairs_a", []),
  ("snowy_castle_battlement_stairs_b",0,"snowy_castle_battlement_stairs_b","bo_snowy_castle_battlement_stairs_b", []),
  ("snowy_castle_gate_house_a",0,"snowy_castle_gate_house_a","bo_snowy_castle_gate_house_a", []),
  ("snowy_castle_round_tower_a",0,"snowy_castle_round_tower_a","bo_snowy_castle_round_tower_a", []),
  ("snowy_castle_square_keep_a",0,"snowy_castle_square_keep_a","bo_snowy_castle_square_keep_a", []),
  ("snowy_castle_stairs_a",sokf_type_ladder,"snowy_castle_stairs_a","bo_snowy_castle_stairs_a", []),

  ("Tgerman_gatehouse",0,"Tgerman_gatehouse","bo_german_gatehouse", []),
  ("Tfrench_round_tower",0,"Tfrench_round_tower","bo_french_round_tower", []),
  ("Tgreek_house_join",0,"Tgreek_house_join","bo_greek_house_join", []),
  ("Toutremer_wall_a",0,"Toutremer_wall_a","bo_outremer_wall_a", []),
  ("Troman_chapel",0,"Troman_chapel","bo_roman_chapel", []),
  ("Tquasbah_walls",0,"Tquasbah_walls","bo_quasbah_walls", []),
  ("Tfrench_keep",0,"Tfrench_keep","bo_french_keep", []),
  ("casa_poble_b",0,"casa_poble_b","bo_castle_h_house_b", []),
  ("casa_poble_a",0,"casa_poble_a","bo_castle_h_house_b", []),
  ("blat",0,"blat","bo_tamare", []),

  ("buttress_2stp_large_a",0,"buttress_2stp_large_a","bo_buttress_2stp_large_a", []),

  ("buttress_large_a",0,"buttress_large_a","bo_buttress_large_a", []),
  ("buttress_simple_a",0,"buttress_simple_a","bo_buttress_simple_a", []),

  ("snowy_castle_tower_a",0,"snowy_castle_tower_a","bo_snowy_castle_tower_a", []),
  ("snowy_castle_battlement_a",0,"snowy_castle_battlement_a","bo_snowy_castle_battlement_a", []),
  ("snowy_castle_battlement_a_destroyed",0,"snowy_castle_battlement_a_destroyed","bo_snowy_castle_battlement_a_destroyed", []),
 
  



 
  ("muralla_mora",0,"muralla_mora","bo_andalus_battlement", []),
  ("porta_mora",0,"porta_mora","bo_andalus_gatehouse", []), 
  ("torre_mora1",0,"torre_mora1","bo_andalus_tower1", []),
  ("torre_mora2",0,"torre_mora2","bo_andalus_tower2", []),
  ("tent",0,"bell_tent","bo_bell_tent", []),
  ("tent_2",0,"command_tent","bo_command_tent", []),
  ("campana_nort",0,"church_nord_tower_a","bo_church_tower_a", []),
  ("absis",0,"absis","bo_castle_e_tower", []),
  ("absis_nord",0,"absis_nord","bo_castle_e_tower", []),
  ("snowy_castle_stairs_a",sokf_type_ladder,"snowy_castle_stairs_a","bo_snowy_castle_stairs_a", []),

  ("square_keep_b",0,"square_keep_b","bo_square_keep_b", []),
  ("square_keep_c",0,"square_keep_c","bo_square_keep_c", []),
  ("square_keep_d",0,"square_keep_d","bo_square_keep_d", []),
  ("square_keep_e",0,"square_keep_e","bo_square_keep_e", []),
  ("square_keep_f",0,"square_keep_f","bo_square_keep_f", []),


  ("square_extension_a",0,"square_extension_a","bo_square_extension_a", []),
  ("square_stairs_a",0,"square_stairs_a","bo_square_stairs_a", []),

  ("castle_courtyard_house_a",0,"castle_courtyard_house_a","bo_castle_courtyard_house_a", []),
  ("castle_courtyard_house_b",0,"castle_courtyard_house_b","bo_castle_courtyard_house_b", []),
  ("castle_courtyard_house_c",0,"castle_courtyard_house_c","bo_castle_courtyard_house_c", []),
  ("castle_courtyard_a",0,"castle_courtyard_a","bo_castle_courtyard_a", []),

  ("gatehouse_b",0,"gatehouse_b","bo_gatehouse_b", []),
  ("castle_gaillard",0,"castle_gaillard","bo_castle_gaillard", []),
  
  ("castle_e_battlement_a",0,"castle_e_battlement_a","bo_castle_e_battlement_a", []),
  ("castle_e_battlement_c",0,"castle_e_battlement_c","bo_castle_e_battlement_c", []),
  ("castle_e_battlement_a_destroyed",0,"castle_e_battlement_a_destroyed","bo_castle_e_battlement_a_destroyed", []),

  ("castle_e_sally_door_a",sokf_moveable|sokf_show_hit_point_bar|sokf_destructible|spr_use_time(0),"castle_e_sally_door_a","bo_castle_e_sally_door_a", [
    check_sally_door_use_trigger,

   (ti_on_init_scene_prop,
    [
      (store_trigger_param_1, ":instance_no"),
      (scene_prop_set_hit_points, ":instance_no", 3000),
    ]),
     
##   (ti_on_scene_prop_destroy,
##    [
##      (play_sound, "snd_dummy_destroyed"),
##      
##      (try_begin),
##        (multiplayer_is_server),
##        (store_trigger_param_1, ":instance_no"),      
##        (store_trigger_param_2, ":attacker_agent_no"),
##
##        (try_begin),
##          (ge, ":attacker_agent_no", 0),
##          (prop_instance_get_position, pos1, ":instance_no"),
##          (agent_get_position, pos2, ":attacker_agent_no"),
##          (assign, ":rotate_side", 80),
##          (try_begin),
##            (position_is_behind_position, pos2, pos1),
##            (val_mul, ":rotate_side", -1),
##          (try_end),
##        (else_try),
##          (assign, ":rotate_side", 80),
##        (try_end),
##      
##        (position_rotate_x, pos1, ":rotate_side"),
##        (prop_instance_animate_to_position, ":instance_no", pos1, 70), #animate to position 1 in 0.7 second
##      (try_end),
##    ]),     

   (ti_on_scene_prop_destroy,
    [
      (play_sound, "snd_dummy_destroyed"),
      
      (assign, ":rotate_side", 86),
      
      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),
		
        (store_trigger_param_1, ":instance_no"),      
        (store_trigger_param_2, ":attacker_agent_no"),

        (set_fixed_point_multiplier, 100),
        (prop_instance_get_position, pos1, ":instance_no"),

        (try_begin),
          (ge, ":attacker_agent_no", 0),
          (agent_get_position, pos2, ":attacker_agent_no"),
          (try_begin),
            (position_is_behind_position, pos2, pos1),
            (val_mul, ":rotate_side", -1),
          (try_end),
        (try_end),
      
        (init_position, pos3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (position_move_y, pos3, -100),
        (else_try),
          (position_move_y, pos3, 100),
        (try_end),
      
        (position_move_x, pos3, -50),
        (position_transform_position_to_parent, pos4, pos1, pos3),
        (position_move_z, pos4, 100),
        (position_get_distance_to_ground_level, ":height_to_terrain", pos4),
        (val_sub, ":height_to_terrain", 100),
        (assign, ":z_difference", ":height_to_terrain"),
        #(assign, reg0, ":z_difference"),
        #(display_message, "@{!}z dif : {reg0}"),
        (val_div, ":z_difference", 3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (val_add, ":rotate_side", ":z_difference"),
        (else_try),
          (val_sub, ":rotate_side", ":z_difference"),
        (try_end),

        (position_rotate_x, pos1, ":rotate_side"),
        (prop_instance_animate_to_position, ":instance_no", pos1, 70), #animate to position 1 in 0.7 second
      (try_end),
    ]),       

    (ti_on_scene_prop_hit,
    [
      (store_trigger_param_1, ":instance_no"),       
      (store_trigger_param_2, ":damage"),
      
      (try_begin),
        (scene_prop_get_hit_points, ":hit_points", ":instance_no"),
        (val_sub, ":hit_points", ":damage"),
        (gt, ":hit_points", 0),
        (play_sound, "snd_dummy_hit"),
      (else_try),
        (neg|multiplayer_is_server),
        (play_sound, "snd_dummy_destroyed"),
      (try_end),

      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),

        (particle_system_burst, "psys_dummy_smoke", pos1, 3),
        (particle_system_burst, "psys_dummy_straw", pos1, 10),
      (try_end),      
    ]),
  ]),

  ("castle_e_corner",0,"castle_e_corner","bo_castle_e_corner", []),
  ("castle_e_corner_b",0,"castle_e_corner_b","bo_castle_e_corner_b", []),
  ("castle_e_corner_c",0,"castle_e_corner_c","bo_castle_e_corner_c", []),
  ("castle_e_stairs_a",0,"castle_e_stairs_a","bo_castle_e_stairs_a", []),
  ("castle_e_tower",0,"castle_e_tower","bo_castle_e_tower", []),
  ("castle_e_gate_house_a",0,"castle_e_gate_house_a","bo_castle_e_gate_house_a", []),
  ("castle_e_keep_a",0,"castle_e_keep_a","bo_castle_e_keep_a", []),
  ("stand_thatched",0,"stand_thatched","bo_stand_thatched", []),
  ("stand_cloth",0,"stand_cloth","bo_stand_cloth", []),
  ("castle_e_house_a",0,"castle_e_house_a","bo_castle_e_house_a", []),
  ("castle_e_house_b",0,"castle_e_house_b","bo_castle_e_house_b", []),

  
  ("arena_block_a",0,"arena_block_a","bo_arena_block_ab", []),
  ("arena_block_b",0,"arena_block_b","bo_arena_block_ab", []),
  ("arena_block_c",0,"arena_block_c","bo_arena_block_c", []),
  ("arena_block_d",0,"arena_block_d","bo_arena_block_def", []),
  ("arena_block_e",0,"arena_block_e","bo_arena_block_def", []),
  ("arena_block_f",0,"arena_block_f","bo_arena_block_def", []),
  ("arena_block_g",0,"arena_block_g","bo_arena_block_ghi", []),
  ("arena_block_h",0,"arena_block_h","bo_arena_block_ghi", []),
  ("arena_block_i",0,"arena_block_i","bo_arena_block_ghi", []),

  ("arena_block_j",0,"arena_block_j","bo_arena_block_j", []),
  ("arena_block_j_awning",0,"arena_block_j_awning","bo_arena_block_j_awning", []),



  ("arena_palisade_a",0,"arena_palisade_a","bo_arena_palisade_a", []),
  ("arena_wall_a",0,"arena_wall_a","bo_arena_wall_ab", []),
  ("arena_wall_b",0,"arena_wall_b","bo_arena_wall_ab", []),
  ("arena_barrier_a",0,"arena_barrier_a","bo_arena_barrier_a", []),
  ("arena_barrier_b",0,"arena_barrier_b","bo_arena_barrier_bc", []),
  ("arena_barrier_c",0,"arena_barrier_c","bo_arena_barrier_bc", []),
  ("arena_tower_a",0,"arena_tower_a","bo_arena_tower_abc", []),
  ("arena_tower_b",0,"arena_tower_b","bo_arena_tower_abc", []),
  ("arena_tower_c",0,"arena_tower_c","bo_arena_tower_abc", []),
  ("arena_spectator_a",0,"arena_spectator_a","0", []),
  ("arena_spectator_b",0,"arena_spectator_b","0", []),
  ("arena_spectator_c",0,"arena_spectator_c","0", []),
  ("arena_spectator_sitting_a",0,"arena_spectator_sitting_a","0", []),
  ("arena_spectator_sitting_b",0,"arena_spectator_sitting_b","0", []),
  ("arena_spectator_sitting_c",0,"arena_spectator_sitting_c","0", []),


  ("courtyard_gate_a",0,"courtyard_entry_a","bo_courtyard_entry_a", []),
  ("courtyard_gate_b",0,"courtyard_entry_b","bo_courtyard_entry_b", []),
  ("courtyard_gate_c",0,"courtyard_entry_c","bo_courtyard_entry_c", []),
  ("courtyard_gate_snowy",0,"courtyard_entry_snowy","bo_courtyard_entry_a", []),

  ("castle_tower_a",0,"castle_tower_a","bo_castle_tower_a", []),
  ("castle_battlement_a",0,"castle_battlement_a","bo_castle_battlement_a", []),
  ("castle_battlement_b",0,"castle_battlement_b","bo_castle_battlement_b", []),
  ("castle_battlement_c",0,"castle_battlement_c","bo_castle_battlement_c", []),

  ("castle_battlement_a_destroyed",0,"castle_battlement_a_destroyed","bo_castle_battlement_a_destroyed", []),
  ("castle_battlement_b_destroyed",0,"castle_battlement_b_destroyed","bo_castle_battlement_b_destroyed", []),

  ("castle_battlement_corner_a",0,"castle_battlement_corner_a","bo_castle_battlement_corner_a", []),
  ("castle_battlement_corner_b",0,"castle_battlement_corner_b","bo_castle_battlement_corner_b", []),
  ("castle_battlement_corner_c",0,"castle_battlement_corner_c","bo_castle_battlement_corner_c", []),
  ("castle_battlement_stairs_a",0,"castle_battlement_stairs_a","bo_castle_battlement_stairs_a", []),
  ("castle_battlement_stairs_b",0,"castle_battlement_stairs_b","bo_castle_battlement_stairs_b", []),
  ("castle_gate_house_a",0,"castle_gate_house_a","bo_castle_gate_house_a", []),
  ("castle_round_tower_a",0,"castle_round_tower_a","bo_castle_round_tower_a", []),
  ("castle_square_keep_a",0,"castle_square_keep_a","bo_castle_square_keep_a", []),
  ("castle_stairs_a",sokf_type_ladder,"castle_stairs_a","bo_castle_stairs_a", []),

  ("castle_drawbridge_open",0,"castle_drawbridges_open","bo_castle_drawbridges_open", []),
  ("castle_drawbridge_closed",0,"castle_drawbridges_closed","bo_castle_drawbridges_closed", []),
  ("spike_group_a",0,"spike_group_a","bo_spike_group_a", []),
  ("spike_a",0,"spike_a","bo_spike_a", []),
  ("belfry_a",sokf_moveable,"belfry_a","bo_belfry_a", []),

  ("belfry_b",sokf_moveable,"belfry_b","bo_belfry_b", []),
  ("belfry_b_platform_a",sokf_moveable,"belfry_b_platform_a","bo_belfry_b_platform_a", []),



  ("belfry_old",0,"belfry_a","bo_belfry_a", []),
  ("belfry_platform_a",sokf_moveable,"belfry_platform_a","bo_belfry_platform_a", []),
  ("belfry_platform_b",sokf_moveable,"belfry_platform_b","bo_belfry_platform_b", []),
  ("belfry_platform_old",0,"belfry_platform_b","bo_belfry_platform_b", []),
  ("belfry_wheel",sokf_moveable,"belfry_wheel",0, []),
  ("belfry_wheel_old",0,"belfry_wheel",0, []),

  ("mangonel",0,"mangonel","bo_mangonel", []),
  ("trebuchet_old",0,"trebuchet_old","bo_trebuchet_old", []),
  ("trebuchet_new",0,"trebuchet_new","bo_trebuchet_old", []),

  ("trebuchet_destructible",sokf_moveable|sokf_show_hit_point_bar|sokf_destructible,"trebuchet_new","bo_trebuchet_old", [
   (ti_on_init_scene_prop,
    [
      (store_trigger_param_1, ":instance_no"),
      (scene_prop_set_hit_points, ":instance_no", 2400),
    ]),
     
   (ti_on_scene_prop_destroy,
    [          
      (play_sound, "snd_dummy_destroyed"),

      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),

        (store_trigger_param_1, ":instance_no"),      
        (prop_instance_get_position, pos1, ":instance_no"),
        (particle_system_burst, "psys_dummy_smoke_big", pos1, 100),
        (particle_system_burst, "psys_dummy_straw_big", pos1, 100),      
        (position_move_z, pos1, -500),
        (position_rotate_x, pos1, 90),
        (prop_instance_animate_to_position, ":instance_no", pos1, 300), #animate to 6 meters below in 6 second

        (try_begin),
          (eq, "$g_round_ended", 0),
          (scene_prop_get_team, ":scene_prop_team_no", ":instance_no"),
          (try_begin),
            (eq, ":scene_prop_team_no", 0),
            (assign, ":scene_prop_team_no_multiplier", -1), 
          (else_try),
            (assign, ":scene_prop_team_no_multiplier", 1), 
          (try_end),

          (try_begin),
            (eq, "$g_number_of_targets_destroyed", 0),
            
            (store_mul, ":target_no_mul_scene_prop_team", ":scene_prop_team_no_multiplier", 2), #2 means destroyed object is a trebuchet

            #for only server itself-----------------------------------------------------------------------------------------------                                                                                                      
            (call_script, "script_show_multiplayer_message", multiplayer_message_type_target_destroyed, ":target_no_mul_scene_prop_team"), 
            #for only server itself-----------------------------------------------------------------------------------------------     
            (get_max_players, ":num_players"),                               
            (try_for_range, ":player_no", 1, ":num_players"),
              (player_is_active, ":player_no"),
              (multiplayer_send_2_int_to_player, ":player_no", multiplayer_event_show_multiplayer_message, multiplayer_message_type_target_destroyed, ":target_no_mul_scene_prop_team"), 
            (try_end),
            (val_add, "$g_number_of_targets_destroyed", 1),
          (else_try),
            (store_mul, ":target_no_mul_scene_prop_team", ":scene_prop_team_no_multiplier", 9), #9 means attackers destroyed all targets

            #for only server itself-----------------------------------------------------------------------------------------------      
            (call_script, "script_show_multiplayer_message", multiplayer_message_type_target_destroyed, ":target_no_mul_scene_prop_team"), 
            #for only server itself-----------------------------------------------------------------------------------------------     
            (get_max_players, ":num_players"),                                
            (try_for_range, ":player_no", 1, ":num_players"),
              (player_is_active, ":player_no"),
              (multiplayer_send_2_int_to_player, ":player_no", multiplayer_event_show_multiplayer_message, multiplayer_message_type_target_destroyed, ":target_no_mul_scene_prop_team"), 
            (try_end),
            (val_add, "$g_number_of_targets_destroyed", 1),
          (try_end),
        (try_end),

        #giving gold for destroying target (for trebuchet)
        #step-1 calculating total damage given to that scene prop
        (assign, ":total_damage_given", 0),
        (get_max_players, ":num_players"),                               
        (try_for_range, ":player_no", 0, ":num_players"), 
          (player_is_active, ":player_no"),
          
          (try_begin),
            (eq, "spr_trebuchet_destructible", "$g_destructible_target_1"),
            (player_get_slot, ":damage_given", ":player_no", slot_player_damage_given_to_target_1),
          (else_try),
            (player_get_slot, ":damage_given", ":player_no", slot_player_damage_given_to_target_2),
          (try_end),

          (val_add, ":total_damage_given", ":damage_given"),
        (try_end),

        #step-2 sharing 1000 gold (if num active players < 20 then 50 * num active players) to players which gave damage with the damage amounts.
        #(scene_prop_get_max_hit_points, ":max_hit_points", ":instance_no"),
        (assign, ":destroy_money_addition", 0),
        (get_max_players, ":num_players"),                               
        (try_for_range, ":player_no", 0, ":num_players"), 
          (player_is_active, ":player_no"),
          (val_add, ":destroy_money_addition", 50),
        (try_end),
      
        (try_begin),
          (ge, ":destroy_money_addition", multi_destroy_target_money_add),
          (assign, ":destroy_money_addition", multi_destroy_target_money_add),
        (try_end),
        (val_mul, ":destroy_money_addition", "$g_multiplayer_battle_earnings_multiplier"),
        (val_div, ":destroy_money_addition", 100),

        (get_max_players, ":num_players"),                               
        (try_for_range, ":player_no", 0, ":num_players"), 
          (player_is_active, ":player_no"),
          
          (try_begin),
            (eq, "spr_trebuchet_destructible", "$g_destructible_target_1"),
            (player_get_slot, ":damage_given", ":player_no", slot_player_damage_given_to_target_1),
          (else_try),
            (player_get_slot, ":damage_given", ":player_no", slot_player_damage_given_to_target_2),
          (try_end),

          (player_get_gold, ":player_gold", ":player_no"), #give money to player which helped flag to be owned by new_flag_owner team

          (val_mul, ":damage_given", ":destroy_money_addition"),
          (store_div, ":gold_earned", ":damage_given", ":total_damage_given"),
        
          (val_add, ":player_gold", ":gold_earned"),
          (player_set_gold, ":player_no", ":player_gold", multi_max_gold_that_can_be_stored),              
        (try_end),      
      (try_end),      
    ]),     

    (ti_on_scene_prop_hit,
    [
      (store_trigger_param_1, ":instance_no"),       
      (store_trigger_param_2, ":damage"),
      
      (try_begin),
        (scene_prop_get_hit_points, ":hit_points", ":instance_no"),
        (val_sub, ":hit_points", ":damage"),
        (gt, ":hit_points", 0),
        (play_sound, "snd_dummy_hit"),
      (else_try),
        (neg|multiplayer_is_server),
        (play_sound, "snd_dummy_destroyed"),
      (try_end),

      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),

        (particle_system_burst, "psys_dummy_smoke", pos1, 3),
        (particle_system_burst, "psys_dummy_straw", pos1, 10),

        (set_fixed_point_multiplier, 1),
        (position_get_x, ":attacker_agent_id", pos2),
        (try_begin),
          (ge, ":attacker_agent_id", 0),
          (agent_is_alive, ":attacker_agent_id"),
          (agent_is_human, ":attacker_agent_id"),
          (neg|agent_is_non_player, ":attacker_agent_id"),
          (agent_get_player_id, ":attacker_player_id", ":attacker_agent_id"),
          (ge, ":attacker_player_id", 0),
          (player_is_active, ":attacker_player_id"),
          (try_begin),
            (eq, "spr_trebuchet_destructible", "$g_destructible_target_1"),
            (player_get_slot, ":damage_given", ":attacker_player_id", slot_player_damage_given_to_target_1),
            (val_add, ":damage_given", ":damage"),
            (player_set_slot, ":attacker_player_id", slot_player_damage_given_to_target_1, ":damage_given"),
          (else_try),
            (player_get_slot, ":damage_given", ":attacker_player_id", slot_player_damage_given_to_target_2),
            (val_add, ":damage_given", ":damage"),
            (player_set_slot, ":attacker_player_id", slot_player_damage_given_to_target_2, ":damage_given"),
          (try_end),
        (try_end),
      (try_end),
    ]),
  ]),


  ("stone_ball",0,"stone_ball","0", []),

  ("village_house_a",0,"village_house_a","bo_village_house_a", []),
  ("village_house_b",0,"village_house_b","bo_village_house_b", []),
  ("village_house_c",0,"village_house_c","bo_village_house_c", []),
  ("village_house_d",0,"village_house_d","bo_village_house_d", []),
  ("farm_house_a",0,"farm_house_a","bo_farm_house_a", []),
  ("farm_house_b",0,"farm_house_b","bo_farm_house_b", []),
  ("farm_house_c",0,"farm_house_c","bo_farm_house_c", []),
  ("mountain_house_a",0,"mountain_house_a","bo_mountain_house_a", []),
  ("mountain_house_b",0,"mountain_house_b","bo_mountain_house_b", []),
  ("village_hut_a",0,"village_hut_a","bo_village_hut_a", []),
  ("crude_fence",0,"fence","bo_fence", []),
  ("crude_fence_small",0,"crude_fence_small","bo_crude_fence_small", []),
  ("crude_fence_small_b",0,"crude_fence_small_b","bo_crude_fence_small_b", []),
  
  ("ramp_12m",0,"ramp_12m","bo_ramp_12m", []),
  ("ramp_14m",0,"ramp_14m","bo_ramp_14m", []),

  ("siege_ladder_6m",sokf_type_ladder,"siege_ladder_move_6m","bo_siege_ladder_move_6m", []), 
  ("siege_ladder_8m",sokf_type_ladder,"siege_ladder_move_8m","bo_siege_ladder_move_8m", []),
  ("siege_ladder_10m",sokf_type_ladder,"siege_ladder_move_10m","bo_siege_ladder_move_10m", []),
  ("siege_ladder_12m",sokf_type_ladder,"siege_ladder_12m","bo_siege_ladder_12m", []),
  ("siege_ladder_14m",sokf_type_ladder,"siege_ladder_14m","bo_siege_ladder_14m", []),

  ("siege_ladder_move_6m",sokf_type_ladder|sokf_moveable|spr_use_time(2),"siege_ladder_move_6m","bo_siege_ladder_move_6m", [    
   check_item_use_trigger,
   check_ladder_animate_trigger,
   check_ladder_animation_finish_trigger,
  ]),  

  ("siege_ladder_move_8m",sokf_type_ladder|sokf_moveable|spr_use_time(2),"siege_ladder_move_8m","bo_siege_ladder_move_8m", [    
   check_item_use_trigger,
   check_ladder_animate_trigger,
   check_ladder_animation_finish_trigger,
  ]),  

  ("siege_ladder_move_10m",sokf_type_ladder|sokf_moveable|spr_use_time(3),"siege_ladder_move_10m","bo_siege_ladder_move_10m", [    
   check_item_use_trigger,
   check_ladder_animate_trigger,
   check_ladder_animation_finish_trigger,
  ]),  

  ("siege_ladder_move_12m",sokf_type_ladder|sokf_moveable|spr_use_time(3),"siege_ladder_move_12m","bo_siege_ladder_move_12m", [    
   check_item_use_trigger,
   check_ladder_animate_trigger,
   check_ladder_animation_finish_trigger,
  ]),  

  ("siege_ladder_move_14m",sokf_type_ladder|sokf_moveable|spr_use_time(4),"siege_ladder_move_14m","bo_siege_ladder_move_14m", [    
   check_item_use_trigger,
   check_ladder_animate_trigger,
   check_ladder_animation_finish_trigger,
  ]),  

  ("portcullis",sokf_moveable,"portcullis_a","bo_portcullis_a", []),
  ("bed_a",0,"bed_a","bo_bed_a", []),
  ("bed_b",0,"bed_b","bo_bed_b", []),
  ("bed_c",0,"bed_c","bo_bed_c", []),
  ("bed_d",0,"bed_d","bo_bed_d", []),
  ("bed_e",0,"bed_e","bo_bed_e", []),

  ("bed_f",0,"bed_f","bo_bed_f", []),

  ("towngate_door_left",sokf_moveable,"door_g_left","bo_door_left", []),
  ("towngate_door_right",sokf_moveable,"door_g_right","bo_door_right", []),
  ("towngate_rectangle_door_left",sokf_moveable,"towngate_rectangle_door_left","bo_towngate_rectangle_door_left", []),
  ("towngate_rectangle_door_right",sokf_moveable,"towngate_rectangle_door_right","bo_towngate_rectangle_door_right", []),
  
  ("door_screen",sokf_moveable,"door_screen","0", []),
  ("door_a",sokf_moveable,"door_a","bo_door_a", []),
  ("door_b",sokf_moveable,"door_b","bo_door_a", []),
  ("door_c",sokf_moveable,"door_c","bo_door_a", []),
  ("door_d",sokf_moveable,"door_d","bo_door_a", []),
  ("tavern_door_a",sokf_moveable,"tavern_door_a","bo_tavern_door_a", []),
  ("tavern_door_b",sokf_moveable,"tavern_door_b","bo_tavern_door_a", []),
  ("door_e_left",sokf_moveable,"door_e_left","bo_door_left", []),
  ("door_e_right",sokf_moveable,"door_e_right","bo_door_right", []),
  ("door_f_left",sokf_moveable,"door_f_left","bo_door_left", []),
  ("door_f_right",sokf_moveable,"door_f_right","bo_door_right", []),
  ("door_h_left",sokf_moveable,"door_g_left","bo_door_left", []),
  ("door_h_right",sokf_moveable,"door_g_right","bo_door_right", []),
  ("draw_bridge_a",0,"draw_bridge_a","bo_draw_bridge_a", []),
  ("chain_1m",0,"chain_1m","0", []),
  ("chain_2m",0,"chain_2m","0", []),
  ("chain_5m",0,"chain_5m","0", []),
  ("chain_10m",0,"chain_10m","0", []),
  ("bridge_modular_a",0,"bridge_modular_a","bo_bridge_modular_a", []),
  ("bridge_modular_b",0,"bridge_modular_b","bo_bridge_modular_b", []),
  ("church_a",0,"church_a","bo_church_a", []),
  ("church_tower_a",0,"church_tower_a","bo_church_tower_a", []),
  ("stone_step_a",0,"floor_stone_a","bo_floor_stone_a", []),
  ("stone_step_b",0,"stone_step_b","0", []),
  ("stone_step_c",0,"stone_step_c","0", []),
  ("stone_heap",0,"stone_heap","bo_stone_heap", []),
  ("stone_heap_b",0,"stone_heap_b","bo_stone_heap", []),

  ("panel_door_a",0,"house_door_a","bo_house_door_a", []),
  ("panel_door_b",0,"house_door_b","bo_house_door_a", []),
  ("smoke_stain",0,"soot_a","0", []),
  ("brazier_with_fire",0,"brazier","bo_brazier",    [
   (ti_on_scene_prop_init,
    [
        (set_position_delta,0,0,85),
        (particle_system_add_new, "psys_brazier_fire_1"),
        (particle_system_add_new, "psys_fire_sparks_1"),

        (set_position_delta,0,0,100),
        (particle_system_add_new, "psys_fire_glow_1"),
        (particle_system_emit, "psys_fire_glow_1",9000000),
    ]),
   ]),

  ("cooking_fire",0,"fire_floor","0",
   [
   (ti_on_scene_prop_init,
    [
        (set_position_delta,0,0,12),
        (particle_system_add_new, "psys_cooking_fire_1"),
        (particle_system_add_new, "psys_fire_sparks_1"),
        (particle_system_add_new, "psys_cooking_smoke"),
        (set_position_delta,0,0,50),
        (particle_system_add_new, "psys_fire_glow_1"),
        (particle_system_emit, "psys_fire_glow_1",9000000),
    ]),
   ]),
  ("cauldron_a",0,"cauldron_a","bo_cauldron_a", []),
  ("fry_pan_a",0,"fry_pan_a","0", []),
  ("tripod_cauldron_a",0,"tripod_cauldron_a","bo_tripod_cauldron_a", []),
  ("tripod_cauldron_b",0,"tripod_cauldron_b","bo_tripod_cauldron_b", []),
  ("open_stable_a",0,"open_stable_a","bo_open_stable_a", []),
  ("open_stable_b",0,"open_stable_b","bo_open_stable_b", []),
  ("plate_a",0,"plate_a","0", []),
  ("plate_b",0,"plate_b","0", []),
  ("plate_c",0,"plate_c","0", []),
  ("lettuce",0,"lettuce","0", []),
  ("hanger",0,"hanger","0", []),
  ("knife_eating",0,"knife_eating","0", []),
  ("colander",0,"colander","0", []),
  ("ladle",0,"ladle","0", []),
  ("spoon",0,"spoon","0", []),
  ("skewer",0,"skewer","0", []),
  ("grape_a",0,"grape_a","0", []),
  ("grape_b",0,"grape_b","0", []),
  ("apple_a",0,"apple_a","0", []),
  ("apple_b",0,"apple_b","0", []),
  ("maize_a",0,"maize_a","0", []),
  ("maize_b",0,"maize_b","0", []),
  ("cabbage",0,"cabbage","0", []),
  ("flax_bundle",0,"raw_flax","0",[]),
  ("olive_plane",0,"olive_plane","0",[]),
  ("grapes_plane",0,"grapes_plane","0",[]),
  ("date_fruit_plane",0,"date_fruit_plane","0",[]),
  ("bowl",0,"bowl_big","0",[]),
  ("bowl_small",0,"bowl_small","0",[]),
  ("dye_blue",0,"raw_dye_blue","0",[]),
  ("dye_red",0,"raw_dye_red","0",[]),
  ("dye_yellow",0,"raw_dye_yellow","0",[]),
  ("basket",0,"basket_small","0",[]),
  ("basket_big",0,"basket_large","0",[]),
  ("basket_big_green",0,"basket_big","0",[]),
  ("leatherwork_frame",0,"leatherwork_frame","0", []),

  ("cabbage_b",0,"cabbage_b","0", []),
  ("bean",0,"bean","0", []),
  ("basket_a",0,"basket_a","bo_basket_a", []),
  ("feeding_trough_a",0,"feeding_trough_a","bo_feeding_trough_a", []),


  ("marrow_a",0,"marrow_a","0", []),
  ("marrow_b",0,"marrow_b","0", []),
  ("squash_plant",0,"marrow_c","0", []),


  ("gatehouse_new_a",sokf_type_ladder,"gatehouse_new_a","bo_gatehouse_new_a", []),
  ("gatehouse_new_b",sokf_type_ladder,"gatehouse_new_b","bo_gatehouse_new_b", []),
  ("gatehouse_new_snowy_a",0,"gatehouse_new_snowy_a","bo_gatehouse_new_b", []),

  ("winch",sokf_moveable,"winch","bo_winch", []),
  
  ("winch_b",sokf_moveable|spr_use_time(5),"winch_b","bo_winch", [
   (ti_on_scene_prop_use,
    [
      (store_trigger_param_1, ":agent_id"),
      (store_trigger_param_2, ":instance_id"),

      #for only server itself-----------------------------------------------------------------------------------------------
      (call_script, "script_use_item", ":instance_id", ":agent_id"),
      #for only server itself-----------------------------------------------------------------------------------------------
      (get_max_players, ":num_players"),                               
      (try_for_range, ":player_no", 1, ":num_players"), #0 is server so starting from 1
        (player_is_active, ":player_no"),
        (multiplayer_send_2_int_to_player, ":player_no", multiplayer_event_use_item, ":instance_id", ":agent_id"),
      (try_end),
    ]),
  ]),
  
  ("drawbridge",0,"drawbridge","bo_drawbridge", []),
  ("gatehouse_door_left",sokf_moveable,"gatehouse_door_left","bo_gatehouse_door_left", []),
  ("gatehouse_door_right",sokf_moveable,"gatehouse_door_right","bo_gatehouse_door_right", []),

  ("cheese_a",0,"cheese_a","0", []),
  ("cheese_b",0,"cheese_b","0", []),
  ("cheese_slice_a",0,"cheese_slice_a","0", []),
  ("bread_a",0,"bread_a","0", []),
  ("bread_b",0,"bread_b","0", []),
  ("bread_slice_a",0,"bread_slice_a","0", []),
  ("fish_a",0,"fish_a","0", []),
  ("fish_roasted_a",0,"fish_roasted_a","0", []),
  ("chicken_roasted",0,"chicken","0", []),
  ("food_steam",0,"0","0",
   [
   (ti_on_scene_prop_init,
    [
     (set_position_delta,0,0,0),
     (particle_system_add_new, "psys_food_steam"),
    ]),
   ]),
  ########################
  ("city_smoke",0,"0","0",
   [
   (ti_on_scene_prop_init,
    [
     (store_time_of_day,reg(12)),
     (neg|is_between,reg(12),5,20),
     (set_position_delta,0,0,0),
     (particle_system_add_new, "psys_night_smoke_1"),
    ]),
   ]),
    ("city_fire_fly_night",0,"0","0",
   [
   (ti_on_scene_prop_init,
    [
     (store_time_of_day,reg(12)),
     (neg|is_between,reg(12),5,20),
     (set_position_delta,0,0,0),
     (particle_system_add_new, "psys_fire_fly_1"),
    ]),
   ]),
    ("city_fly_day",0,"0","0",
   [
   (ti_on_scene_prop_init,
    [
     (particle_system_add_new, "psys_bug_fly_1"),
    ]),
   ]),
    ("flue_smoke_tall",0,"0","0",
   [
   (ti_on_scene_prop_init,
    [
     (particle_system_add_new, "psys_flue_smoke_tall"),
    ]),
   ]),
      ("flue_smoke_short",0,"0","0",
   [
   (ti_on_scene_prop_init,
    [
     (particle_system_add_new, "psys_flue_smoke_short"),
    ]),
   ]),
      ("moon_beam",0,"0","0",
   [
   (ti_on_scene_prop_init,
    [
     (particle_system_add_new, "psys_moon_beam_1"),
     (particle_system_add_new, "psys_moon_beam_paricle_1"),
    ]),
   ]),
    ("fire_small",0,"0","0",
   [
   (ti_on_scene_prop_init,
    [
     (particle_system_add_new, "psys_fireplace_fire_small"),
    ]),
   ]),
  ("fire_big",0,"0","0",
   [
   (ti_on_scene_prop_init,
    [
     (particle_system_add_new, "psys_fireplace_fire_big"),
    ]),
   ]),
    ("battle_field_smoke",0,"0","0",
   [
   (ti_on_scene_prop_init,
    [
     (particle_system_add_new, "psys_war_smoke_tall"),
    ]),
   ]),
      ("Village_fire_big",0,"0","0",
   [
   (ti_on_scene_prop_init,
    [
     (particle_system_add_new, "psys_village_fire_big"),
     (set_position_delta,0,0,100),
     (particle_system_add_new, "psys_village_fire_smoke_big"),
    ]),
   ]),
  #########################
  ("candle_a",0,"candle_a","0",
   [
   (ti_on_scene_prop_init,
    [
     (set_position_delta,0,0,27),
     (particle_system_add_new, "psys_candle_light"),
    ]),
   ]),
  ("candle_b",0,"candle_b","0",
   [
   (ti_on_scene_prop_init,
    [
     (set_position_delta,0,0,25),
     (particle_system_add_new, "psys_candle_light"),
    ]),
   ]),
  ("candle_c",0,"candle_c","0",   [
   (ti_on_scene_prop_init,
    [
     (set_position_delta,0,0,10),
     (particle_system_add_new, "psys_candle_light_small"),
    ]),
   ]),
  ("lamp_a",0,"lamp_a","0",   [
   (ti_on_scene_prop_init,
    [
     (set_position_delta,66,0,2),
     (particle_system_add_new, "psys_candle_light"),
    ]),
   ]),

  ("lamp_b",0,"lamp_b","0",   [
   (ti_on_scene_prop_init,
    [
     (set_position_delta,65,0,-7),
     (particle_system_add_new, "psys_lamp_fire"),
     (set_position_delta,70,0,-5),
     (particle_system_add_new, "psys_fire_glow_1"),
     (particle_system_emit, "psys_fire_glow_1",9000000),
     (play_sound, "snd_fire_loop", 0),
    ]),
   ]),

  ("hook_a",0,"hook_a","0", []),
  ("window_night",0,"window_night","0", []),
  ("fried_pig",0,"pork","0", []),
  ("village_oven",0,"village_oven","bo_village_oven", []),
  ("dungeon_water_drops",0,"0","0",
   [
   (ti_on_scene_prop_init,
    [
     (particle_system_add_new, "psys_dungeon_water_drops"),
    ]),
   ]),
  ("shadow_circle_1",0,"shadow_circle_1","0", []),
  ("shadow_circle_2",0,"shadow_circle_2","0", []),
  ("shadow_square_1",0,"shadow_square_1","0", []),
  ("shadow_square_2",0,"shadow_square_2","0", []),
  ("wheelbarrow",0,"wheelbarrow","bo_wheelbarrow", []),
  ("gourd",sokf_moveable|sokf_destructible|spr_hit_points(1),"gourd","bo_gourd",
   [
     (ti_on_scene_prop_destroy,
      [
        (store_trigger_param_1, ":instance_no"),
        (val_add, "$g_last_destroyed_gourds", 1),
        (prop_instance_get_position, pos1, ":instance_no"),
        (copy_position, pos2, pos1),
        (position_set_z, pos2, -100000),
        (particle_system_burst, "psys_gourd_smoke", pos1, 2),
        (particle_system_burst, "psys_gourd_piece_1", pos1, 1),
        (particle_system_burst, "psys_gourd_piece_2", pos1, 5),
        (prop_instance_animate_to_position, ":instance_no", pos2, 1),
        (play_sound, "snd_gourd_destroyed"),
        ]),
     ]),

 ("gourd_spike",sokf_moveable,"gourd_spike","bo_gourd_spike",[]),

 ("obstacle_fence_1",0,"fence","bo_fence", []),
 ("obstacle_fallen_tree_a",0,"destroy_tree_a","bo_destroy_tree_a", []),
 ("obstacle_fallen_tree_b",0,"destroy_tree_b","bo_destroy_tree_b", []),
 ("siege_wall_a",0,"siege_wall_a","bo_siege_wall_a", []),
 ("siege_large_shield_a",0,"siege_large_shield_a","bo_siege_large_shield_a", []),
 ("granary_a",0,"granary_a","bo_granary_a", []),
 ("small_wall_connect_a",0,"small_wall_connect_a","bo_small_wall_connect_a", []),

 ("full_stable_a",0,"full_stable_a","bo_full_stable_a", []),
 ("full_stable_b",0,"full_stable_b","bo_full_stable_b", []),
 ("full_stable_c",0,"full_stable_c","bo_full_stable_c", []),
 ("full_stable_d",0,"full_stable_d","bo_full_stable_d", []),

 ("arabian_house_a",0,"arabian_house_a","bo_arabian_house_a", []),
 ("arabian_house_b",0,"arabian_house_b","bo_arabian_house_b", []),
 ("arabian_house_c",0,"arabian_house_c","bo_arabian_house_c", []),
 ("arabian_house_d",0,"arabian_house_d","bo_arabian_house_d", []),
 ("arabian_house_e",0,"arabian_house_e","bo_arabian_house_e", []),
 ("arabian_house_f",0,"arabian_house_f","bo_arabian_house_f", []),
 ("arabian_house_g",0,"arabian_house_g","bo_arabian_house_g", []),
 ("arabian_house_h",0,"arabian_house_h","bo_arabian_house_h", []),
 ("arabian_house_i",0,"arabian_house_i","bo_arabian_house_i", []),
 ("arabian_square_keep_a",0,"arabian_square_keep_a","bo_arabian_square_keep_a", []),
 
 ("Tcastle_e_battlement_c",0,"Tcastle_e_battlement_c","bo_castle_e_battlement_c", []),
 ("Tmuralla_battlement_a",0,"Tmuralla_battlement_a","bo_castle_e_battlement_a", []),
 ("Tcastle_e_battlement_a_destroyed",0,"Tcastle_e_battlement_a_destroyed","bo_castle_e_battlement_a_destroyed", []),
 ("Tcastle_e_corner_b",0,"Tcastle_e_corner_b","bo_castle_e_corner_b", []),
 ("Tcastle_e_house_a",0,"Tcastle_e_house_a","bo_castle_e_house_a", []),
 ("Tcastle_e_house_b",0,"Tcastle_e_house_b","bo_castle_e_house_b", []),
 ("T2castle_e_house_b",0,"T2castle_e_house_b","bo_castle_e_house_b", []),
 ("T3castle_e_house_b",0,"T3castle_e_house_b","bo_castle_e_house_b", []),
 ("Tcastle_e_gate_house_a",0,"Tcastle_e_gate_house_a","bo_castle_e_gate_house_a", []),
 ("Tcastle_e_corner",0,"Tcastle_e_corner","bo_castle_e_corner", []), 
 ("arabian_passage_house_a",0,"arabian_passage_house_a","bo_arabian_passage_house_a", []),
 ("arabian_wall_a",0,"arabian_wall_a","bo_arabian_wall_a", []),
 ("arabian_wall_b",0,"arabian_wall_b","bo_arabian_wall_b", []),
 ("arabian_ground_a",0,"arabian_ground_a","bo_arabian_ground_a", []),
 ("arabian_parterre_a",0,"arabian_parterre_a","bo_arabian_parterre_a", []),
 ("well_shaft",0,"well_shaft","bo_well_shaft", []),
 ("horse_mill",0,"horse_mill","bo_horse_mill", []),
 ("horse_mill_collar",0,"horse_mill_collar","bo_horse_mill_collar", []),
 ("arabian_stable",0,"arabian_stable","bo_arabian_stable", []),
 ("arabian_tent",0,"arabian_tent","bo_arabian_tent", []),
 ("arabian_tent_b",0,"arabian_tent_b","bo_arabian_tent_b", []),
 ("desert_plant_a",0,"desert_plant_a","0", []),

 ("arabian_castle_battlement_a",0,"arabian_castle_battlement_a","bo_arabian_castle_battlement_a", []),
 ("arabian_castle_battlement_b_destroyed",0,"arabian_castle_battlement_b_destroyed","bo_arabian_castle_battlement_b_destroyed", []),
 ("arabian_castle_battlement_c",0,"arabian_castle_battlement_c","bo_arabian_castle_battlement_c", []),
 ("arabian_castle_battlement_d",0,"arabian_castle_battlement_d","bo_arabian_castle_battlement_d", []),
 ("arabian_castle_corner_a",0,"arabian_castle_corner_a","bo_arabian_castle_corner_a", []),
 ("arabian_castle_stairs",sokf_type_ladder,"arabian_castle_stairs","bo_arabian_castle_stairs", []),
 ("arabian_castle_stairs_b",sokf_type_ladder,"arabian_castle_stairs_b","bo_arabian_castle_stairs_b", []),
 ("arabian_castle_stairs_c",sokf_type_ladder,"arabian_castle_stairs_c","bo_arabian_castle_stairs_c", []),
 ("arabian_castle_battlement_section_a",0,"arabian_castle_battlement_section_a","bo_arabian_castle_battlement_section_a", []),

 ("arabian_castle_gate_house_a",0,"arabian_castle_gate_house_a","bo_arabian_castle_gate_house_a", []),
 ("arabian_castle_house_a",0,"arabian_castle_house_a","bo_arabian_castle_house_a", []),
 ("arabian_castle_house_b",0,"arabian_castle_house_b","bo_arabian_castle_house_b", []),
 ("arabian_castle_keep_a",0,"arabian_castle_keep_a","bo_arabian_castle_keep_a", []),

 ("Tcastle_f_gatehouse_a",0,"Tcastle_f_gatehouse_a","bo_castle_f_gatehouse_a", []),
 ("Tcastle_battlement_corner_a",0,"Tcastle_battlement_corner_a","bo_castle_battlement_corner_a", []),
 ("Tcastle_battlement_c",0,"Tcastle_battlement_c","bo_castle_battlement_c", []),
 ("Tcastle_battlement_b_destroyed",0,"Tcastle_battlement_b_destroyed","bo_castle_battlement_b_destroyed", []),

 ("Tcastle_battlement_a",0,"Tcastle_battlement_a","bo_castle_battlement_a", []),
 ("Tcastle_battlement_b",0,"Tcastle_battlement_b","bo_castle_battlement_b", []),
 ("Tcastle_battlement_corner_b",0,"Tcastle_battlement_corner_b","bo_castle_battlement_corner_b", []),
 ("Tcastle_battlement_stairs_b",0,"Tcastle_battlement_stairs_b","bo_castle_battlement_stairs_b", []),
 ("Tcastle_battlement_a_destroyed",0,"Tcastle_battlement_a_destroyed","bo_castle_battlement_a_destroyed", []), 

 ("arabian_house_a2",0,"arabian_house_a2","bo_arabian_house_a2", []),
 ("arabian_village_house_a",0,"arabian_village_house_a","bo_arabian_village_house_a", []),
 ("arabian_village_house_b",0,"arabian_village_house_b","bo_arabian_village_house_b", []),
 ("arabian_village_house_c",0,"arabian_village_house_c","bo_arabian_village_house_c", []),
 ("arabian_village_house_d",0,"arabian_village_house_d","bo_arabian_village_house_d", []),

 ("arabian_village_stable",0,"arabian_village_stable","bo_arabian_village_stable", []),
 ("arabian_village_hut",0,"arabian_village_hut","bo_arabian_village_hut", []),
 ("arabian_village_stairs",sokf_type_ladder,"arabian_village_stairs","bo_arabian_village_stairs", []),

 ("tree_a01",0,"tree_a01","bo_tree_a01", []),

 ("stairs_a",sokf_type_ladder,"stairs_a","bo_stairs_a", []),

 ("headquarters_flag_red",sokf_moveable|sokf_face_player,"tutorial_flag_red","0", []),
 ("headquarters_flag_blue",sokf_moveable|sokf_face_player,"tutorial_flag_blue","0", []),
 ("headquarters_flag_gray",sokf_moveable|sokf_face_player,"tutorial_flag_yellow","0", []),  

 ("headquarters_flag_red_code_only",sokf_moveable|sokf_face_player,"mp_flag_red","0", []),
 ("headquarters_flag_blue_code_only",sokf_moveable|sokf_face_player,"mp_flag_blue","0", []),
 ("headquarters_flag_gray_code_only",sokf_moveable|sokf_face_player,"mp_flag_white","0", []),  
 ("headquarters_pole_code_only",sokf_moveable,"mp_flag_pole","0", []),

 ("headquarters_flag_swadian",sokf_moveable|sokf_face_player,"flag_swadian","0", []),
 ("headquarters_flag_vaegir",sokf_moveable|sokf_face_player,"flag_vaegir","0", []),
 ("headquarters_flag_khergit",sokf_moveable|sokf_face_player,"flag_khergit","0", []),
 ("headquarters_flag_nord",sokf_moveable|sokf_face_player,"flag_nord","0", []),
 ("headquarters_flag_rhodok",sokf_moveable|sokf_face_player,"flag_rhodok","0", []),
 ("headquarters_flag_sarranid",sokf_moveable|sokf_face_player,"flag_sarranid","0", []),

 ("glow_a", 0, "glow_a", "0", []),
 ("glow_b", 0, "glow_b", "0", []),

 ("arabian_castle_corner_b",0,"arabian_castle_corner_b","bo_arabian_castle_corner_b", []),

  ("dummy_a_undestructable",sokf_destructible,"arena_archery_target_b","bo_arena_archery_target_b",
   [
     (ti_on_init_scene_prop,
      [
        (store_trigger_param_1, ":instance_no"),
        (scene_prop_set_hit_points, ":instance_no", 10000000),
        ]),
     (ti_on_scene_prop_hit,
      [
        (store_trigger_param_1, ":instance_no"),
        (store_trigger_param_2, ":damage"),
        (try_begin),
          (set_fixed_point_multiplier, 1),
          (position_get_x, ":attacker_agent_id", pos2),
          (get_player_agent_no, ":player_agent"),
          (eq, ":player_agent", ":attacker_agent_id"),
          (assign, reg60, ":damage"),
          (display_message, "str_delivered_damage"),
          (eq, "$g_tutorial_training_ground_horseman_trainer_state", 6),
          (eq, "$g_tutorial_training_ground_horseman_trainer_completed_chapters", 1),
          (prop_instance_get_variation_id_2, ":var_id_2", ":instance_no"),
          (val_sub, ":var_id_2", 1),
          (eq, "$g_tutorial_training_ground_current_score", ":var_id_2"),
          (val_add, "$g_tutorial_training_ground_current_score", 1),
        (try_end),
        (play_sound, "snd_dummy_hit"),
        (particle_system_burst, "psys_dummy_smoke", pos1, 3),
        (particle_system_burst, "psys_dummy_straw", pos1, 10),
    ]),
  ]),
 ("cave_entrance_1",0,"cave_entrance_1","bo_cave_entrance_1", []),

  ("pointer_arrow", 0, "pointer_arrow", "0", []),
  ("fireplace_d_interior",0,"fireplace_d","bo_fireplace_d", []),
  ("ship_sail_off",0,"ship_sail_off","bo_ship_sail_off", []),
  ("ship_sail_off_b",0,"ship_sail_off_b","bo_ship_sail_off", []),
  ("ship_c_sail_off",0,"ship_c_sail_off","bo_ship_c_sail_off", []),
  ("ramp_small_a",0,"ramp_small_a","bo_ramp_small_a", []),
  ("castle_g_battlement_b",0,"castle_g_battlement_b","bo_castle_g_battlement_b", []),
  ("box_a_dynamic",sokf_moveable|sokf_dynamic_physics,"box_a","bo_box_a", []),

 ("desert_field",0,"desert_field","bo_desert_field", []),

 ("water_river",0,"water_plane","0", []),
# ("viking_house_a",0,"viking_house_a","bo_viking_house_a", []),
# ("viking_house_b",0,"viking_house_b","bo_viking_house_b", []),
# ("viking_house_c",0,"viking_house_c","bo_viking_house_c", []),
# ("viking_house_d",0,"viking_house_d","bo_viking_house_d", []),
# ("viking_house_e",0,"viking_house_e","bo_viking_house_e", []),
# ("viking_stable_a",0,"viking_stable_a","bo_viking_stable_a", []),
# ("viking_keep",0,"viking_keep","bo_viking_keep", []),

# ("viking_house_c_destroy",0,"viking_house_c_destroy","bo_viking_house_c_destroy", []),
# ("viking_house_b_destroy",0,"viking_house_b_destroy","bo_viking_house_b_destroy", []),
 
 ("Tcourtyard_entry_b",0,"Tcourtyard_entry_b","bo_courtyard_entry_b", []),
 ("Tsmall_wall_e",0,"Tsmall_wall_e","bo_small_wall_d", []),
 ("Tsquare_tower_roof_a",0,"Tsquare_tower_roof_a","0", []),
 ("Tcastle_battlement_corner_f",0,"Tcastle_battlement_corner_f","bo_castle_battlement_corner_a", []),
 ("Tcastle_battlement_corner_q",0,"Tcastle_battlement_corner_q","bo_castle_battlement_corner_b", []),
 ("Tdestroy_bridge_a",0,"Tdestroy_bridge_a","bo_destroy_bridge_a", []),
 ("Tcourtyard_entry_C",0,"Tcourtyard_entry_C","bo_Tcourtyard_entry_C", []),

 ("Tchurch_a",0,"Tchurch_a","bo_church_a", []),
 ("Tabsis",0,"Tabsis","bo_castle_e_tower", []), 

 ("harbour_a",0,"harbour_a","bo_harbour_a", []),
 ("sea_foam_a",0,"0","0",
   [
   (ti_on_scene_prop_init,
    [
     (particle_system_add_new, "psys_sea_foam_a"),
    ]),
   ]),
 ("Tarena_wall_b",0,"Tarena_wall_b","bo_arena_wall_ab", []),   
# ("viking_keep_destroy",0,"viking_keep_destroy","bo_viking_keep_destroy", []),
 ("viking_keep_destroy_door",0,"viking_keep_destroy_door","bo_viking_keep_destroy_door", []),
 ("earth_tower_small_b",0,"earth_tower_small_b","bo_earth_tower_small_b", []),
 ("earth_gate_house_b",0,"earth_gate_house_b","bo_earth_gate_house_b", []),
 ("earth_tower_a",0,"earth_tower_a","bo_earth_tower_a", []),
 ("earth_stairs_c",0,"earth_stairs_c","bo_earth_stairs_c", []),
 
  ("earth_sally_gate_left",sokf_moveable|sokf_show_hit_point_bar|sokf_destructible|spr_use_time(0),"earth_sally_gate_left","bo_earth_sally_gate_left", [
    check_sally_door_use_trigger_double,

   (ti_on_init_scene_prop,
    [
      (store_trigger_param_1, ":instance_no"),
      (scene_prop_set_hit_points, ":instance_no", 2000),
    ]),
     
   (ti_on_scene_prop_destroy,
    [
      (play_sound, "snd_dummy_destroyed"),
      
      (assign, ":rotate_side", 86),
      
      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),

        (store_trigger_param_1, ":instance_no"),      
        (store_trigger_param_2, ":attacker_agent_no"),

        (set_fixed_point_multiplier, 100),
        (prop_instance_get_position, pos1, ":instance_no"),

        (try_begin),
          (ge, ":attacker_agent_no", 0),
          (agent_get_position, pos2, ":attacker_agent_no"),
          (try_begin),
            (position_is_behind_position, pos2, pos1),
            (val_mul, ":rotate_side", -1),
          (try_end),
        (try_end),
      
        (init_position, pos3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (position_move_y, pos3, -100),
        (else_try),
          (position_move_y, pos3, 100),
        (try_end),
      
        (position_move_x, pos3, -50),
        (position_transform_position_to_parent, pos4, pos1, pos3),
        (position_move_z, pos4, 100),
        (position_get_distance_to_ground_level, ":height_to_terrain", pos4),
        (val_sub, ":height_to_terrain", 100),
        (assign, ":z_difference", ":height_to_terrain"),
        (val_div, ":z_difference", 3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (val_add, ":rotate_side", ":z_difference"),
        (else_try),
          (val_sub, ":rotate_side", ":z_difference"),
        (try_end),

        (position_rotate_x, pos1, ":rotate_side"),
        (prop_instance_animate_to_position, ":instance_no", pos1, 70), #animate to position 1 in 0.7 second
      (try_end),
    ]),       

    (ti_on_scene_prop_hit,
    [
      (store_trigger_param_1, ":instance_no"),       
      (store_trigger_param_2, ":damage"),
      
      (try_begin),
        (scene_prop_get_hit_points, ":hit_points", ":instance_no"),
        (val_sub, ":hit_points", ":damage"),
        (gt, ":hit_points", 0),
        (play_sound, "snd_dummy_hit"),
      (else_try),
        (neg|multiplayer_is_server),
        (play_sound, "snd_dummy_destroyed"),
      (try_end),

      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),

        (particle_system_burst, "psys_dummy_smoke", pos1, 3),
        (particle_system_burst, "psys_dummy_straw", pos1, 10),
      (try_end),      
    ]),
  ]),

  ("earth_sally_gate_right",sokf_moveable|sokf_show_hit_point_bar|sokf_destructible|spr_use_time(0),"earth_sally_gate_right","bo_earth_sally_gate_right", [
    check_sally_door_use_trigger_double,

   (ti_on_init_scene_prop,
    [
      (store_trigger_param_1, ":instance_no"),
      (scene_prop_set_hit_points, ":instance_no", 2000),
    ]),
     
   (ti_on_scene_prop_destroy,
    [
      (play_sound, "snd_dummy_destroyed"),
      
      (assign, ":rotate_side", 86),
      
      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),

        (store_trigger_param_1, ":instance_no"),      
        (store_trigger_param_2, ":attacker_agent_no"),

        (set_fixed_point_multiplier, 100),
        (prop_instance_get_position, pos1, ":instance_no"),

        (try_begin),
          (ge, ":attacker_agent_no", 0),
          (agent_get_position, pos2, ":attacker_agent_no"),
          (try_begin),
            (position_is_behind_position, pos2, pos1),
            (val_mul, ":rotate_side", -1),
          (try_end),
        (try_end),
      
        (init_position, pos3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (position_move_y, pos3, -100),
        (else_try),
          (position_move_y, pos3, 100),
        (try_end),
      
        (position_move_x, pos3, -50),
        (position_transform_position_to_parent, pos4, pos1, pos3),
        (position_move_z, pos4, 100),
        (position_get_distance_to_ground_level, ":height_to_terrain", pos4),
        (val_sub, ":height_to_terrain", 100),
        (assign, ":z_difference", ":height_to_terrain"),
        (val_div, ":z_difference", 3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (val_add, ":rotate_side", ":z_difference"),
        (else_try),
          (val_sub, ":rotate_side", ":z_difference"),
        (try_end),

        (position_rotate_x, pos1, ":rotate_side"),
        (prop_instance_animate_to_position, ":instance_no", pos1, 70), #animate to position 1 in 0.7 second
      (try_end),
    ]),       

    (ti_on_scene_prop_hit,
    [
      (store_trigger_param_1, ":instance_no"),       
      (store_trigger_param_2, ":damage"),
      
      (try_begin),
        (scene_prop_get_hit_points, ":hit_points", ":instance_no"),
        (val_sub, ":hit_points", ":damage"),
        (gt, ":hit_points", 0),
        (play_sound, "snd_dummy_hit"),
      (else_try),
        (neg|multiplayer_is_server),
        (play_sound, "snd_dummy_destroyed"),
      (try_end),

      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),

        (particle_system_burst, "psys_dummy_smoke", pos1, 3),
        (particle_system_burst, "psys_dummy_straw", pos1, 10),
      (try_end),      
    ]),
  ]),

 #("earth_sally_gate_left",0,"earth_sally_gate_left","bo_earth_sally_gate_left", []),
 #("earth_sally_gate_right",0,"earth_sally_gate_right","bo_earth_sally_gate_right", []),


  ("barrier_box",sokf_invisible|sokf_type_barrier3d,"barrier_box","bo_barrier_box", []),
  ("barrier_capsule",sokf_invisible|sokf_type_barrier3d,"barrier_capsule","bo_barrier_capsule", []),
  ("barrier_cone" ,sokf_invisible|sokf_type_barrier3d,"barrier_cone" ,"bo_barrier_cone" , []),
  ("barrier_sphere" ,sokf_invisible|sokf_type_barrier3d,"barrier_sphere" ,"bo_barrier_sphere" , []),

  ("viking_keep_destroy_sally_door_right",sokf_moveable|sokf_show_hit_point_bar|sokf_destructible|spr_use_time(0),"viking_keep_destroy_sally_door_right","bo_viking_keep_destroy_sally_door_right", [
    check_sally_door_use_trigger_double,

   (ti_on_init_scene_prop,
    [
      (store_trigger_param_1, ":instance_no"),
      (scene_prop_set_hit_points, ":instance_no", 3000),
    ]),
     
   (ti_on_scene_prop_destroy,
    [
      (play_sound, "snd_dummy_destroyed"),
      
      (assign, ":rotate_side", 86),
      
      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),

        (store_trigger_param_1, ":instance_no"),      
        (store_trigger_param_2, ":attacker_agent_no"),

        (set_fixed_point_multiplier, 100),
        (prop_instance_get_position, pos1, ":instance_no"),

        (try_begin),
          (ge, ":attacker_agent_no", 0),
          (agent_get_position, pos2, ":attacker_agent_no"),
          (try_begin),
            (position_is_behind_position, pos2, pos1),
            (val_mul, ":rotate_side", -1),
          (try_end),
        (try_end),
      
        (init_position, pos3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (position_move_y, pos3, -100),
        (else_try),
          (position_move_y, pos3, 100),
        (try_end),
      
        (position_move_x, pos3, -50),
        (position_transform_position_to_parent, pos4, pos1, pos3),
        (position_move_z, pos4, 100),
        (position_get_distance_to_ground_level, ":height_to_terrain", pos4),
        (val_sub, ":height_to_terrain", 100),
        (assign, ":z_difference", ":height_to_terrain"),
        (val_div, ":z_difference", 3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (val_add, ":rotate_side", ":z_difference"),
        (else_try),
          (val_sub, ":rotate_side", ":z_difference"),
        (try_end),

        (position_rotate_x, pos1, ":rotate_side"),
        (prop_instance_animate_to_position, ":instance_no", pos1, 70), #animate to position 1 in 0.7 second
      (try_end),
    ]),       

    (ti_on_scene_prop_hit,
    [
      (store_trigger_param_1, ":instance_no"),       
      (store_trigger_param_2, ":damage"),
      
      (try_begin),
        (scene_prop_get_hit_points, ":hit_points", ":instance_no"),
        (val_sub, ":hit_points", ":damage"),
        (gt, ":hit_points", 0),
        (play_sound, "snd_dummy_hit"),
      (else_try),
        (neg|multiplayer_is_server),
        (play_sound, "snd_dummy_destroyed"),
      (try_end),

      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),

        (particle_system_burst, "psys_dummy_smoke", pos1, 3),
        (particle_system_burst, "psys_dummy_straw", pos1, 10),
      (try_end),      
    ]),
  ]),

  ("viking_keep_destroy_sally_door_left",sokf_moveable|sokf_show_hit_point_bar|sokf_destructible|spr_use_time(0),"viking_keep_destroy_sally_door_left","bo_viking_keep_destroy_sally_door_left", [
    check_sally_door_use_trigger_double,

   (ti_on_init_scene_prop,
    [
      (store_trigger_param_1, ":instance_no"),
      (scene_prop_set_hit_points, ":instance_no", 3000),
    ]),
     
   (ti_on_scene_prop_destroy,
    [
      (play_sound, "snd_dummy_destroyed"),
      
      (assign, ":rotate_side", 86),
      
      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),

        (store_trigger_param_1, ":instance_no"),      
        (store_trigger_param_2, ":attacker_agent_no"),

        (set_fixed_point_multiplier, 100),
        (prop_instance_get_position, pos1, ":instance_no"),

        (try_begin),
          (ge, ":attacker_agent_no", 0),
          (agent_get_position, pos2, ":attacker_agent_no"),
          (try_begin),
            (position_is_behind_position, pos2, pos1),
            (val_mul, ":rotate_side", -1),
          (try_end),
        (try_end),
      
        (init_position, pos3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (position_move_y, pos3, -100),
        (else_try),
          (position_move_y, pos3, 100),
        (try_end),
      
        (position_move_x, pos3, -50),
        (position_transform_position_to_parent, pos4, pos1, pos3),
        (position_move_z, pos4, 100),
        (position_get_distance_to_ground_level, ":height_to_terrain", pos4),
        (val_sub, ":height_to_terrain", 100),
        (assign, ":z_difference", ":height_to_terrain"),
        (val_div, ":z_difference", 3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (val_add, ":rotate_side", ":z_difference"),
        (else_try),
          (val_sub, ":rotate_side", ":z_difference"),
        (try_end),

        (position_rotate_x, pos1, ":rotate_side"),
        (prop_instance_animate_to_position, ":instance_no", pos1, 70), #animate to position 1 in 0.7 second
      (try_end),
    ]),       

    (ti_on_scene_prop_hit,
    [
      (store_trigger_param_1, ":instance_no"),       
      (store_trigger_param_2, ":damage"),
      
      (try_begin),
        (scene_prop_get_hit_points, ":hit_points", ":instance_no"),
        (val_sub, ":hit_points", ":damage"),
        (gt, ":hit_points", 0),
        (play_sound, "snd_dummy_hit"),
      (else_try),
        (neg|multiplayer_is_server),
        (play_sound, "snd_dummy_destroyed"),
      (try_end),

      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),

        (particle_system_burst, "psys_dummy_smoke", pos1, 3),
        (particle_system_burst, "psys_dummy_straw", pos1, 10),
      (try_end),      
    ]),
  ]),

  ("castle_f_door_b",sokf_moveable|sokf_show_hit_point_bar|sokf_destructible|spr_use_time(0),"castle_e_sally_door_a","bo_castle_e_sally_door_a", [
    check_castle_door_use_trigger,

   (ti_on_init_scene_prop,
    [
      (store_trigger_param_1, ":instance_no"),
      (scene_prop_set_hit_points, ":instance_no", 1000),
    ]),
     
   (ti_on_scene_prop_destroy,
    [
      (play_sound, "snd_dummy_destroyed"),
      
      (assign, ":rotate_side", 86),
      
      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),

        (store_trigger_param_1, ":instance_no"),      
        (store_trigger_param_2, ":attacker_agent_no"),

        (set_fixed_point_multiplier, 100),
        (prop_instance_get_position, pos1, ":instance_no"),

        (try_begin),
          (ge, ":attacker_agent_no", 0),
          (agent_get_position, pos2, ":attacker_agent_no"),
          (try_begin),
            (position_is_behind_position, pos2, pos1),
            (val_mul, ":rotate_side", -1),
          (try_end),
        (try_end),
      
        (init_position, pos3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (position_move_y, pos3, -100),
        (else_try),
          (position_move_y, pos3, 100),
        (try_end),
      
        (position_move_x, pos3, -50),
        (position_transform_position_to_parent, pos4, pos1, pos3),
        (position_move_z, pos4, 100),
        (position_get_distance_to_ground_level, ":height_to_terrain", pos4),
        (val_sub, ":height_to_terrain", 100),
        (assign, ":z_difference", ":height_to_terrain"),
        #(assign, reg0, ":z_difference"),
        #(display_message, "@{!}z dif : {reg0}"),
        (val_div, ":z_difference", 3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (val_add, ":rotate_side", ":z_difference"),
        (else_try),
          (val_sub, ":rotate_side", ":z_difference"),
        (try_end),

        (position_rotate_x, pos1, ":rotate_side"),
        (prop_instance_animate_to_position, ":instance_no", pos1, 70), #animate to position 1 in 0.7 second
      (try_end),
    ]),       
  
    (ti_on_scene_prop_hit,
    [
      (store_trigger_param_1, ":instance_no"),       
      (store_trigger_param_2, ":damage"),
      
      (try_begin),
        (scene_prop_get_hit_points, ":hit_points", ":instance_no"),
        (val_sub, ":hit_points", ":damage"),
        (gt, ":hit_points", 0),
        (play_sound, "snd_dummy_hit"),
      (else_try),
        (neg|multiplayer_is_server),
        (play_sound, "snd_dummy_destroyed"),
      (try_end),

      (try_begin),
        (this_or_next|multiplayer_is_server),
		(neg|game_in_multiplayer_mode),

        (particle_system_burst, "psys_dummy_smoke", pos1, 3),
        (particle_system_burst, "psys_dummy_straw", pos1, 10),
      (try_end),      
    ]),
  ]),

 ("ctf_flag_kingdom_1", sokf_moveable|sokf_face_player, "ctf_flag_kingdom_1", "0", []),
 ("ctf_flag_kingdom_2", sokf_moveable|sokf_face_player, "ctf_flag_kingdom_2", "0", []),
 ("ctf_flag_kingdom_3", sokf_moveable|sokf_face_player, "ctf_flag_kingdom_3", "0", []),
 ("ctf_flag_kingdom_4", sokf_moveable|sokf_face_player, "ctf_flag_kingdom_4", "0", []),
 ("ctf_flag_kingdom_5", sokf_moveable|sokf_face_player, "ctf_flag_kingdom_5", "0", []),
 ("ctf_flag_kingdom_6", sokf_moveable|sokf_face_player, "ctf_flag_kingdom_6", "0", []),
 ("ctf_flag_kingdom_7", sokf_moveable|sokf_face_player, "ctf_flag_kingdom_7", "0", []),

 ("headquarters_flag_rebel",sokf_moveable|sokf_face_player,"flag_rebel","0", []),
  ("arabian_lighthouse_a",0,"arabian_lighthouse_a","bo_arabian_lighthouse_a", []),
  ("Tfrench_battlement_a",0,"Tfrench_battlement_a","bo_french_battlement_a", []),
  ("arabian_ramp_a",0,"arabian_ramp_a","bo_arabian_ramp_a", []),
  ("arabian_ramp_b",0,"arabian_ramp_b","bo_arabian_ramp_b", []),
  
  ("winery_interior",0,"winery_interior","bo_winery_interior", []),
  ("winery_barrel_shelf",0,"winery_barrel_shelf","bo_winery_barrel_shelf", []),
  ("winery_wall_shelf",0,"winery_wall_shelf","bo_winery_wall_shelf", []),
  ("winery_huge_barrel",0,"winery_huge_barrel","bo_winery_huge_barrel", []),
  ("winery_wine_press",0,"winery_wine_press","bo_winery_wine_press", []),
  ("winery_middle_barrel",0,"winery_middle_barrel","bo_winery_middle_barrel", []),
  ("winery_wine_cart_small_loaded",0,"winery_wine_cart_small_loaded","bo_winery_wine_cart_small_loaded", []),
  ("winery_wine_cart_small_empty",0,"winery_wine_cart_small_empty","bo_winery_wine_cart_small_empty", []),
  ("winery_wine_cart_empty",0,"winery_wine_cart_empty","bo_winery_wine_cart_empty", []),
  ("winery_wine_cart_loaded",0,"winery_wine_cart_loaded","bo_winery_wine_cart_loaded", []),
  
  ("weavery_interior",0,"weavery_interior","bo_weavery_interior", []),
  ("weavery_loom_a",0,"weavery_loom_a","bo_weavery_loom_a", []),
  ("weavery_spinning_wheel",0,"weavery_spinning_wheel","bo_weavery_spinning_wheel", []),
  
  ("mill_interior",0,"mill_interior","bo_mill_interior", []),
  ("mill_flour_sack", 0,"mill_flour_sack","bo_mill_flour_sack", []),
  ("mill_flour_sack_desk_a", 0,"mill_flour_sack_desk_a","bo_mill_flour_sack_desk_a", []),
  ("mill_flour_sack_desk_b", 0,"mill_flour_sack_desk_b","bo_mill_flour_sack_desk_b", []),
  
  ("smithy_interior", 0,"smithy_interior","bo_smithy_interior", []),
  ("smithy_grindstone_wheel", 0,"smithy_grindstone_wheel","bo_smithy_grindstone_wheel", []),
  ("smithy_forge_bellows", 0,"smithy_forge_bellows","bo_smithy_forge_bellows", []),
  ("smithy_forge", 0,"smithy_forge","bo_smithy_forge", []),
  ("smithy_anvil", 0,"smithy_anvil","bo_smithy_anvil", []),
  
  ("tannery_hide_a", 0,"tannery_hide_a","bo_tannery_hide_a", []),
  ("tannery_hide_b", 0,"tannery_hide_b","bo_tannery_hide_b", []),
  ("tannery_pools_a", 0,"tannery_pools_a","bo_tannery_pools_a", []),
  ("tannery_pools_b", 0,"tannery_pools_b","bo_tannery_pools_b", []),

 ("fountain", 0, "fountain", "bo_fountain", []),

 ("rhodok_houses_a",0,"rhodok_houses_a","bo_rhodok_houses_a", []),
 ("rhodok_houses_b",0,"rhodok_houses_b","bo_rhodok_houses_b", []),
 ("rhodok_houses_c",0,"rhodok_houses_c","bo_rhodok_houses_c", []),
 ("rhodok_houses_d",0,"rhodok_houses_d","bo_rhodok_houses_d", []),
 ("rhodok_houses_e",0,"rhodok_houses_e","bo_rhodok_houses_e", []),
 ("rhodok_house_passage_a",0,"rhodok_house_passage_a","bo_rhodok_house_passage_a", []),

 ("Tfrench_battlement_a_destroyed",0,"Tfrench_battlement_a_destroyed","bo_french_battlement_a_destroyed", []),
 ("Tfrench_battlement_b",0,"Tfrench_battlement_b","bo_french_battlement_b", []),
 ("Tfrench_battlement_c",0,"Tfrench_battlement_c","bo_french_battlement_c", []),
 ("Tinterior_castle_n",0,"Tinterior_castle_n","bo_interior_castle_n", []),
 ("Tcourtyard_entry_w",0,"Tcourtyard_entry_w","bo_Tcourtyard_entry_w", []),
 ("rhodok_house_passage_a",0,"rhodok_house_passage_a","bo_rhodok_house_passage_a", []),

 ("bridge_b",0,"bridge_b","bo_bridge_b", []),
 
("brewery_pool", 0,"brewery_pool","bo_brewery_pool", []),
("brewery_big_bucket", 0,"brewery_big_bucket","bo_brewery_big_bucket", []),
("brewery_interior", 0,"brewery_interior","bo_brewery_interior", []),
("brewery_bucket_platform_a", 0,"brewery_bucket_platform_a","bo_brewery_bucket_platform_a", []),
("brewery_bucket_platform_b", 0,"brewery_bucket_platform_b","bo_brewery_bucket_platform_b", []),


("weavery_dye_pool_r",0,"weavery_dye_pool_r","bo_weavery_dye_pool_r", []),
("weavery_dye_pool_y",0,"weavery_dye_pool_y","bo_weavery_dye_pool_y", []),
("weavery_dye_pool_b",0,"weavery_dye_pool_b","bo_weavery_dye_pool_b", []),
("weavery_dye_pool_p",0,"weavery_dye_pool_p","bo_weavery_dye_pool_p", []),
("weavery_dye_pool_g",0,"weavery_dye_pool_g","bo_weavery_dye_pool_g", []),

("oil_press_interior",0,"oil_press_interior","bo_oil_press_interior", []),

    ("city_swad_01" ,0,"city_swad_01" ,"bo_city_swad_01" , []),
    ("city_swad_02" ,0,"city_swad_02" ,"bo_city_swad_02" , []),
    ("city_swad_03" ,0,"city_swad_03" ,"bo_city_swad_03" , []),
    ("city_swad_04" ,0,"city_swad_04" ,"bo_city_swad_04" , []),
    ("city_swad_passage_01" ,0,"city_swad_passage_01" ,"bo_city_swad_passage_01" , []),
    ("city_swad_05" ,0,"city_swad_05" ,"bo_city_swad_05" , []),

  ("arena_block_j_a",0,"arena_block_j_a","bo_arena_block_j_a", []),
  ("arena_underway_a",0,"arena_underway_a","bo_arena_underway_a", []),
  ("arena_circle_a",0,"arena_circle_a","bo_arena_circle_a", []),

  #Tosca############################################################################
  ("Tfrench_keepSur",0,"Tfrench_keepSur","bo_french_keep", []),
  ("Tstone_ballN",0,"stone_ball","0", []),
  ("Tstone_ballS",0,"stone_ball","0", []),
  ("Tspike_group_a",0,"spike_group_a","bo_spike_group_a", []),
  ("Tspike_a",0,"spike_a","bo_spike_a", []),
  ("Tdestroy_castle_b",0,"Tdestroy_castle_b","bo_destroy_castle_b", []),
  ("Tandalus_wall",0,"Tandalus_wall","bo_andalus_wall", []),
  ("Tandalus_wallB",0,"Tandalus_wallB","bo_andalus_wall", []),
  ("casa_poble_c",0,"casa_poble_c","bo_castle_h_house_b", []),
  ("casa_poble_d",0,"casa_poble_d","bo_castle_h_house_b", []),
  ("bridge_modular_c",0,"bridge_modular_c","bo_bridge_modular_a", []),
  ("bridge_modular_d",0,"bridge_modular_d","bo_bridge_modular_b", []),
  ("buttress_large_C",0,"buttress_large_C","bo_buttress_large_a", []),
  ("buttress_simple_B",0,"buttress_simple_B","bo_buttress_simple_a", []),
  ("cypress_b",0,"cypress_b","bo_cypress_b", []),
  ("desert_tree_aa",0,"desert_tree_aa","bo_desert_tree_aa", []),
  ("Talmohad_tower",0,"Talmohad_tower","bo_almohad_tower", []),
  ("Talmohad_tower_d",0,"Talmohad_tower_d","bo_almohad_tower_d", []),
  ("Tgreat_stairs",0,"Tgreat_stairs","bo_great_stairs", []),
  ("Tumayyad_gatehouse",0,"Tumayyad_gatehouse","bo_umayyad_gatehouse", []),
  ("Tumayyad_tower_a",0,"Tumayyad_tower_a","bo_umayyad_tower_a", []),
  ("Tumayyad_tower_b",0,"Tumayyad_tower_b","bo_umayyad_tower_b", []),
  ("Tumayyad_corner",0,"Tumayyad_corner","bo_umayyad_corner", []),
  ("Tumayyad_battlement_a",0,"Tumayyad_battlement_a","bo_umayyad_battlement_a", []),
  ("Tumayyad_battlement_b",0,"Tumayyad_battlement_b","bo_umayyad_battlement_b", []),
  ("Tumayyad_battlement_c",0,"Tumayyad_battlement_c","bo_umayyad_battlement_c", []),
  ("Tcastle3_tower1",0,"Tcastle3_tower1","bo_castle3_tower1", []),
  ("Tcastle3_battlement",0,"Tcastle3_battlement","bo_castle3_battlement", []),
  ("Tporta_mora",0,"Tporta_mora","bo_andalus_gatehouse", []),
  ("Tportamora2",0,"Tportamora2","bo_Tportamora2", []),
  ("Tportamora3",0,"Tportamora3","bo_Tportamora2", []),
  ("Tcastle_square_keep_b",0,"Tcastle_square_keep_b","bo_castle_square_keep_a", []),
  ("Tcastle_square_keep_a",0,"Tcastle_square_keep_a","bo_castle_square_keep_a", []),
  ("palace_floor",0,"palace_floor","bo_palace_floor", []),
  ("muslim_palace",0,"muslim_palace","bo_muslim_palace", []),
  ("Tpassage_house_dd",0,"Tpassage_house_dd","bo_Tpassage_house", []),
  ("Tpassage_house_cc",0,"Tpassage_house_cc","bo_Tpassage_house", []),
  ("Tpassage_house_ee",0,"Tpassage_house_ee","bo_Tpassage_house", []),
  ("Tpassage_house_bb",0,"Tpassage_house_bb","bo_Tpassage_house_b", []),
  ("Tsmall_wall_a",0,"Tsmall_wall_a","bo_small_wall_a", []),
  ("Tsmall_wall_b",0,"Tsmall_wall_b","bo_small_wall_a", []),
  ("Tsmall_wall_C",0,"Tsmall_wall_C","bo_small_wall_d", []),
  ("buttress_simple_E",0,"buttress_simple_E","bo_buttress_simple_a", []),
  ("ch_cross_1",0,"ch_cross_1","bo_ch_cross_1", []),
  ("water_mill",0,"water_mill","bo_water_mill", []),
  ("T3castle_e_house_c",0,"T3castle_e_house_c","bo_castle_e_house_a", []),
  ("Tcastle_h_house_d",0,"Tcastle_h_house_d","bo_castle_h_house_b", []),
  ("village_sur_shed_d",0,"village_sur_shed_d","bo_village_shed_b", []),
  ("Tcastle_e_house_ab",0,"Tcastle_e_house_ab","bo_castle_e_house_a", []),
  ("Talmohad_tower_c",0,"Talmohad_tower_c","bo_almohad_tower_c", []),
  ("Tandalus_wallC",0,"Tandalus_wallC","bo_andalus_wall", []),
  ("almohad_battlement_destroyed",0,"almohad_battlement_destroyed","bo_almohad_battlement_destroyed", []),
  ("Tpassage_house_ff",0,"Tpassage_house_ff","bo_Tpassage_house", []),
  ("arabian_castle_stairs_bd",0,"arabian_castle_stairs_bd","bo_arabian_castle_stairs_b", []),
  ("arabian_castle_stairs_ce",0,"arabian_castle_stairs_ce","bo_arabian_castle_stairs_c", []),

  
  #pedres 
  ("crusader_rock_a",0,"crusader_rock_a","bo_crusader_rock_a", []),
  ("crusader_rock_b",0,"crusader_rock_b","bo_crusader_rock_b", []),
  ("crusader_rock_big_2",0,"crusader_rock_big_2","bo_crusader_rock_big_2", []),
  ("crusader_rock_big_1",0,"crusader_rock_big_1","bo_crusader_rock_big_1", []),
  ("sa_large_stones_2",0,"sa_large_stones_2","bo_sa_large_stones_2", []),
  ("sa_large_stones_3",0,"sa_large_stones_3","bo_sa_large_stones_3", []),
  ("sa_large_stones_4",0,"sa_large_stones_4","bo_sa_large_stones_4", []),
  ("sa_large_stones_5",0,"sa_large_stones_5","bo_sa_large_stones_5", []),
  ("sa_large_stones_10",0,"sa_large_stones_10","bo_sa_large_stones_10", []),
  ("sa_large_stones_11",0,"sa_large_stones_11","bo_sa_large_stones_11", []),
  ("sa_large_stones_13",0,"sa_large_stones_13","bo_sa_large_stones_13", []),
  ("sa_large_stones_22",0,"sa_large_stones_22","bo_sa_large_stones_22", []),
  ("sa_large_stones_30",0,"sa_large_stones_30","bo_sa_large_stones_30", []),
#tapizes
    ("wall_painting_1",0,"wall_painting_1","0", []),
    ("wall_painting_2",0,"wall_painting_2","0", []),
    ("wall_painting_3",0,"wall_painting_3","0", []),
    ("wall_painting_4",0,"wall_painting_4","0", []),
    ("wall_painting_5",0,"wall_painting_5","0", []),
    ("wall_painting_6",0,"wall_painting_6","0", []),
  #interior
  ("Tinterior_castle_a",0,"bo_interior_castle_n","0", []),
  #barcos JBJ
  ("dhow",0,"dhow","bo_dhow", []),
  ("dhow_izar",0,"dhow_izar","bo_dhow_izar", []),
  ("galera",0,"galera","bo_galera", []),
  ("galera_mercante_c",0,"galera_mercante_c","bo_galera", []),
  ("galera_corsaria",0,"galera_corsaria","bo_galera_corsaria", []),
  ("galera_izar",0,"galera_izar","bo_galera_izar", []),
  ("jebeque",0,"jebeque","bo_jebeque", []),
  ("jebeque_izar",0,"jebeque_izar","bo_jebeque_izar", []),
  ("jebeque_mercante",0,"jebeque_mercante","bo_jebeque", []),
  ("jebeque_corsario",0,"jebeque_corsario","bo_jebeque_corsario", []),
  ("coca",0,"coca","bo_coca", []),
  ("coca_izar",0,"coca_izar","bo_coca_izar", []),
  ("coca_mercante",0,"coca_mercante","bo_coca", []), 
  # v.2
  ("galera_rota",0,"galera_rota","bo_galera_rota", []),
  ("coca_rota",0,"coca_rota","bo_coca_rota", []),
  ("galera_remos",0,"galera_remos","bo_galera_remos", []),
  ("mastil0",0,"mastil0","bo_mastil0", []),
  ("mastil1",0,"mastil1","bo_mastil1", []),
  ("mastil2",0,"mastil2","bo_mastil2", []),
  ("barril",0,"barril","bo_barril", []),
  ("remo0",0,"remo0","bo_remo0", []),
  ("madera0",0,"madera0","bo_madera0", []),
  ("casco0",0,"casco0","bo_casco0", []),

  
  
  #fin barcos JBJ

  #espectadores
  ("espectador1",0,"espectador1","0", []),
  ("espectador2",0,"espectador2","0", []),
  ("espectador3",0,"espectador3","0", []),
  ("espectador_sentado1",0,"espectador_sentado1","0", []),
  ("espectador_sentado2",0,"espectador_sentado2","0", []),
  ("espectador_sentado3",0,"espectador_sentado3","0", []),
  ("espectador_grupo1",0,"espectador_grupo1","0", []),
  ("espectador_grupo2",0,"espectador_grupo2","0", []),
  ("espectador_grupo3",0,"espectador_grupo3","0", []),
  ("espectador_grupo4",0,"espectador_grupo4","0", []),
  ("espectador_grupo5",0,"espectador_grupo5","0", []),
  #fin espectadores

  #romanic

  ("Tporta_romanica",0,"Tporta_romanica","bo_Tporta_romanica", []),
  ("Tfinestra_romanica",0,"Tfinestra_romanica","0", []),
  ("Tfinestra_romanica2",0,"Tfinestra_romanica2","0", []),

  ("Tfinestra_romanica3",0,"Tfinestra_romanica3","0", []),
  ("Tfinestra_romanica4",0,"Tfinestra_romanica4","0", []),

  ("campanario_romanico_1",0,"campanario_romanico_1","bo_campanario_romanico", []),
  ("campanario_romanico_2",0,"campanario_romanico_2","bo_campanario_romanico", []),
  ("campanario_romanico_3",0,"campanario_romanico_3","bo_campanario_romanico", []),
  ("campanario_romanico_4",0,"campanario_romanico_4","bo_campanario_romanico", []),
  ("campanario_romanico_5",0,"campanario_romanico_5","bo_campanario_romanico", []),

  #fin romanic

  #arcs moros

  ("arco_moro_1",0,"arco_moro_1","bo_arco_moro_1", []),
  ("arco_moro_2",0,"arco_moro_2","bo_arco_moro_1", []),
  ("arco_moro_3",0,"arco_moro_3","bo_arco_moro_1", []),
  ("arco_moro_4",0,"arco_moro_4","bo_arco_moro_1", []),
  ("arco_moro_5",0,"arco_moro_5","bo_arco_moro_1", []),
  ("arco_moro_6",0,"arco_moro_6","bo_arco_moro_1", []),
  ("arco_moro_7",0,"arco_moro_7","bo_arco_moro_1", []),
  ("arco_moro_8",0,"arco_moro_8","bo_arco_moro_1", []),

  ("arco_moro_apuntado_1",0,"arco_moro_apuntado_1","bo_arco_moro_apuntado_1", []),
  ("arco_moro_apuntado_2",0,"arco_moro_apuntado_2","bo_arco_moro_apuntado_1", []),
  ("arco_moro_apuntado_3",0,"arco_moro_apuntado_3","bo_arco_moro_apuntado_1", []),
  ("arco_moro_apuntado_4",0,"arco_moro_apuntado_4","bo_arco_moro_apuntado_1", []),
  ("arco_moro_apuntado_5",0,"arco_moro_apuntado_5","bo_arco_moro_apuntado_1", []),
  ("arco_moro_apuntado_6",0,"arco_moro_apuntado_6","bo_arco_moro_apuntado_1", []),
  ("arco_moro_apuntado_7",0,"arco_moro_apuntado_7","bo_arco_moro_apuntado_1", []),
  ("arco_moro_apuntado_8",0,"arco_moro_apuntado_8","bo_arco_moro_apuntado_1", []),


  ("finestra_mora_1",0,"finestra_mora_1","0", []),
  ("finestra_mora_2",0,"finestra_mora_2","0", []),
  ("finestra_mora_3",0,"finestra_mora_3","0", []),
  ("finestra_mora_4",0,"finestra_mora_4","0", []),
  ("finestra_mora_5",0,"finestra_mora_5","0", []),
  ("finestra_mora_6",0,"finestra_mora_6","0", []),
  ("finestra_mora_7",0,"finestra_mora_7","0", []),
  ("finestra_mora_8",0,"finestra_mora_8","0", []),
  ("finestra_mora_9",0,"finestra_mora_9","0", []),


  ("finestra_mora_10",0,"finestra_mora_10","0", []),
  ("finestra_mora_11",0,"finestra_mora_11","0", []),
  ("finestra_mora_12",0,"finestra_mora_12","0", []),
  ("finestra_mora_13",0,"finestra_mora_13","0", []),
  ("finestra_mora_14",0,"finestra_mora_14","0", []),
  ("finestra_mora_15",0,"finestra_mora_15","0", []),
  ("finestra_mora_16",0,"finestra_mora_16","0", []),
  ("finestra_mora_17",0,"finestra_mora_17","0", []),
  ("finestra_mora_18",0,"finestra_mora_18","0", []),
  ("finestra_mora_19",0,"finestra_mora_19","0", []),
  ("finestra_mora_20",0,"finestra_mora_20","0", []),
  ("finestra_mora_21",0,"finestra_mora_21","0", []),
  ("finestra_mora_22",0,"finestra_mora_22","0", []),
  ("finestra_mora_23",0,"finestra_mora_23","0", []),
  ("finestra_mora_24",0,"finestra_mora_24","0", []),

  ("puerta_mora_1",0,"puerta_mora_1","bo_puerta_mora_1", []),
  ("puerta_mora_2",0,"puerta_mora_2","bo_puerta_mora_2", []),

  ("puerta_mora_3",0,"puerta_mora_3","bo_puerta_mora_1", []),
  ("puerta_mora_4",0,"puerta_mora_4","bo_puerta_mora_2", []),

  ("puerta_mora_5",0,"puerta_mora_5","bo_puerta_mora_1", []),
  ("puerta_mora_6",0,"puerta_mora_6","bo_puerta_mora_2", []),

  ("puerta_mora_7",0,"puerta_mora_7","bo_puerta_mora_7", []),
  ("puerta_mora_8",0,"puerta_mora_8","bo_puerta_mora_7", []),
  ("puerta_mora_9",0,"puerta_mora_9","bo_puerta_mora_7", []),

  ("minarete_rural",0,"minarete_rural","bo_moorish_minaret", []),
  ("techo_mezquita",0,"techo_mezquita","0", []),
 
  


  
  #fin arcs moros

  ("muralla_burgo1",0,"muralla_burgo1","bo_muralla_burgo1", []),
  ("arco_burgo1",0,"arco_burgo1","bo_arco_burgo1", []),

  ("muralla_burgo2",0,"muralla_burgo2","bo_muralla_burgo1", []),
  ("arco_burgo2",0,"arco_burgo2","bo_arco_burgo1", []),

  
  ####  
  
  ("rope_bridge_15m",0,"rope_bridge_15m","bo_rope_bridge_15m", []),
  ("tree_house_a",0,"tree_house_a","bo_tree_house_a", []),
  ("tree_house_guard_a",0,"tree_house_guard_a","bo_tree_house_guard_a", []),
  ("tree_house_guard_b",0,"tree_house_guard_b","bo_tree_house_guard_b", []),
  ("tree_shelter_a",0,"tree_shelter_a","bo_tree_shelter_a", []),
  ("yellow_fall_leafs_a",0,"0","0",
   [
   (ti_on_scene_prop_init,
    [
     (particle_system_add_new, "psys_fall_leafs_a"),
    ]),
   ]),

## Where the fuck did that come from?
 ("rock_bridge_a",0,"rock_bridge_a","bo_rock_bridge_a", []),
 ("suspension_bridge_a",0,"suspension_bridge_a","bo_suspension_bridge_a", []),
 ("mine_a",0,"mine_a","bo_mine_a", []),


## Deployable Pavise begin
  ("pavise",sokf_moveable|sokf_destructible,"pavise_prop","bo_pavise", [
    #check_castle_door_use_trigger,

   (ti_on_init_scene_prop,
    [
      (store_trigger_param_1, ":instance_no"),
      (scene_prop_set_hit_points, ":instance_no", 100),
    ]),
     
   (ti_on_scene_prop_destroy,
    [
      (play_sound, "snd_dummy_destroyed"),
     
      (assign, ":rotate_side", 86),
     
      (try_begin),
        (this_or_next|multiplayer_is_server),
      (neg|game_in_multiplayer_mode),

        (store_trigger_param_1, ":instance_no"),     
        (store_trigger_param_2, ":attacker_agent_no"),

        (set_fixed_point_multiplier, 100),
        (prop_instance_get_position, pos1, ":instance_no"),

        (try_begin),
          (ge, ":attacker_agent_no", 0),
          (agent_get_position, pos2, ":attacker_agent_no"),
          (try_begin),
            (position_is_behind_position, pos2, pos1),
            (val_mul, ":rotate_side", -1),
          (try_end),
        (try_end),
     
        (init_position, pos3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (position_move_y, pos3, -100),
        (else_try),
          (position_move_y, pos3, 100),
        (try_end),
     
        (position_move_x, pos3, -50),
        (position_transform_position_to_parent, pos4, pos1, pos3),
        (position_move_z, pos4, 100),
        (position_get_distance_to_ground_level, ":height_to_terrain", pos4),
        (val_sub, ":height_to_terrain", 100),
        (assign, ":z_difference", ":height_to_terrain"),
        #(assign, reg0, ":z_difference"),
        #(display_message, "@{!}z dif : {reg0}"),
        (val_div, ":z_difference", 3),

        (try_begin),
          (ge, ":rotate_side", 0),
          (val_add, ":rotate_side", ":z_difference"),
        (else_try),
          (val_sub, ":rotate_side", ":z_difference"),
        (try_end),

        (position_rotate_x, pos1, ":rotate_side"),
        (prop_instance_animate_to_position, ":instance_no", pos1, 70), #animate to position 1 in 0.7 second
      (try_end),
    ]),       
 
    (ti_on_scene_prop_hit,
    [
      (store_trigger_param_1, ":instance_no"),       
      (store_trigger_param_2, ":damage"),
     
      (try_begin),
        (scene_prop_get_hit_points, ":hit_points", ":instance_no"),
        (val_sub, ":hit_points", ":damage"),
        (gt, ":hit_points", 0),
        (play_sound, "snd_dummy_hit"),
      (else_try),
        (neg|multiplayer_is_server),
        (play_sound, "snd_dummy_destroyed"),
      (try_end),

      (try_begin),
        (this_or_next|multiplayer_is_server),
      (neg|game_in_multiplayer_mode),

        (particle_system_burst, "psys_dummy_smoke", pos1, 3),
        (particle_system_burst, "psys_dummy_straw", pos1, 10),
      (try_end),     
    ]),
  ]),
## Deployable Pavise end

#TEMPERED     ########################  ADDED SCENE PROPS BEGIN  ####################
("bell_tent"							,sokf_type_barrier|sokf_type_ai_limiter	,"bell_tent"							,"bo_bell_tent"							, []),
("bell_tent_inventory"					,sokf_type_container					,"bell_tent"							,"bo_bell_tent"							, []),
("bell_tent_noinventory"				,0										,"bell_tent"							,"bo_bell_tent"							, []),
("command_tent"							,0										,"command_tent"							,"bo_command_tent"						, []),
("siege_camp_spikes"					,0										,"spike_group_a"						,"bo_spike_group_a"						, []),
("siege_camp_tower"						,0										,"belfry_b"								,"bo_belfry_b"							, []),
("siege_camp_bridge"					,0										,"belfry_platform_b"					,"bo_belfry_platform_b"					, []),
#TEMPERED     ########################   ADDED SCENE PROPS END   ####################

# CWE PROPS
("sa_teat_box_a_dynamic", sokf_moveable|sokf_dynamic_physics, "box_a", "bo_box_a", [
    (ti_on_scene_prop_hit,[
      (store_trigger_param_1, ":var0"),
      (set_fixed_point_multiplier, 100),
      (position_set_x, pos0, 2500),
      (position_set_y, pos0, 80),
      (position_set_z, pos0, 0),
      (position_set_x, pos0, 0),
      (position_set_y, pos0, 0),
      (position_set_z, pos0, 30000),
      (prop_instance_dynamics_apply_impulse, ":var0", 0),
    ]),
  ]),
("crusader_knight_spear_a_2_sp", sokf_moveable|sokf_dynamic_physics, "crusader_knight_spear_a_2", "bo_crusader_knight_spear_a_2", []),
("crusader_knight_spear_b_2_sp", sokf_moveable|sokf_dynamic_physics, "crusader_knight_spear_b_2", "bo_crusader_knight_spear_a_2", []),

# Damascus
("damask_1_a", 0, "damask_1_a", "damask_1_a_col", []),
("damask_stena_1_a", 0, "damask_stena_1_a", "damask_stena_1_a_col", []),
("damask_stena_2_b", 0, "damask_stena_2_b", "damask_stena_2_b_col", []),
("damask_stena_3_c", 0, "damask_stena_3_c", "damask_stena_3_c_col", []),
("damask_stena_3_c_long", 0, "damask_stena_3_c_long", "bo_damask_stena_3_c_long", []),
("damask_stena_4_d", 0, "damask_stena_4_d", "damask_stena_4_d_col", []),
("damask_stena_5_e", 0, "damask_stena_5_e", "damask_stena_5_e_col", []),
("damask_stena_6_f", 0, "damask_stena_6_f", "damask_stena_6_f_col", []),
("damask_stena_7_g", 0, "damask_stena_7_g", "damask_stena_7_g_col", []),
("damask_stena_8_h", 0, "damask_stena_8_h", "damask_stena_8_h_col", []),
("damask_stena_9_k", 0, "damask_stena_9_k", "damask_stena_9_k_col", []),
("damask_stena_10_m", 0, "damask_stena_10_m", "damask_stena_10_m_col", []),
("damask_stena_11_m", 0, "damask_stena_11_m", "damask_stena_11_m_col", []),
("damask_stena_12_m", 0, "damask_stena_12_m", "damask_stena_12_m_col", []),
("damask_bashna_1_a", 0, "damask_bashna_1_a", "damask_bashna_1_a_col", []),
("damask_bashna_2_b", 0, "damask_bashna_2_b", "damask_bashna_2_b_col", []),
("damask_bashna_3_c", 0, "damask_bashna_3_c", "damask_bashna_3_c_col", []),
("damask_overhang_a", 0, "overhang_Damask_a", "overhang_Damask_a_col", []),
("damask_overhang_b", 0, "overhang_Damask_b", "overhang_Damask_b_col", []),
("damask_mechet_1_a", 0, "damask_mechet_1_a", "damask_mechet_1_a_col", []),
("damask_minaret_1_a", 0, "damask_minaret_1_a", "damask_minaret_1_a_col", []),
("damask_arka_1_a", 0, "damask_arka_1_a", "damask_arka_1_a_col", []),
("damask_arka_b", 0, "damask_arka_b", "bo_damask_arka_b", []),
("damask_arka_b_var1", 0, "damask_arka_b_var1", "bo_damask_arka_b", []),
("damask_rinok_1_a", 0, "damask_rinok_1_a", "damask_rinok_1_a_col", []),
("damask_dom_a", 0, "damask_dom_a", "damask_dom_a_col", []),
("damask_dom_a_ladder", 0, "damask_dom_a_ladder", "damask_dom_a_ladder_col", []),
("damask_mosque_ground_a", 0, "damask_mosque_ground_a", "Jerusalem_ground_d_col", []),
("damask_mosque_stairs_high_c", 0, "damask_mosque_stairs_high_c", "Jerusalem_stairs_high_c_col", []),
("damask_house_a", 0, "damask_house_a", "bo_eastern_house_with_interior_a", []),
("damask_house_a_var_1", 0, "damask_house_a_var_1", "bo_eastern_house_with_interior_a_var_1", []),
("damask_house_a_var_2", 0, "damask_house_a_var_2", "bo_eastern_house_with_interior_a_var_2", []),
("damask_house_a_var_3", 0, "damask_house_a_var_3", "bo_eastern_house_with_interior_a_var_3", []),
("damask_house_a_var_4", 0, "damask_house_a_var_4", "bo_eastern_house_with_interior_a_var_4", []),
("damask_house_a_var_5", 0, "damask_house_a_var_5", "bo_eastern_house_with_interior_a_var_5", []),
("damask_house_b", 0, "damask_house_b", "bo_eastern_house_with_interior_b", []),
("damask_house_b_open", 0, "damask_house_b_open", "bo_eastern_house_with_interior_b_open_var1", []),
("damask_house_c", 0, "damask_house_c", "bo_eastern_house_with_interior_c", []),
("damask_house_c_var_1", 0, "damask_house_c_var_1", "bo_eastern_house_with_interior_c", []),
("damask_house_d", 0, "damask_house_d", "bo_eastern_house_with_interior_d", []),
("damask_house_d_var1", 0, "damask_house_d_var1", "bo_eastern_house_with_interior_d", []),
("damask_house_e", 0, "damask_house_e", "bo_eastern_house_with_interior_e", []),
("damask_house_f", 0, "damask_house_f", "bo_eastern_house_with_interior_f", []),
("damask_house_g", 0, "damask_house_g", "bo_eastern_house_with_interior_g", []),
("damask_house_s", 0, "damask_house_s", "bo_eastern_house_with_interior_s", []),
("damask_building_a", 0, "damask_building_a", "bo_eastern_building_with_interior_a", []),
("damask_building_b", 0, "damask_building_b", "bo_eastern_building_with_interior_b", []),
("damask_wall_1", 0, "damask_wall_1", "bo_eastern_wall_1", []),
("damask_wall_2", 0, "damask_wall_2", "bo_eastern_wall_2", []),
("damask_wall_3", 0, "damask_wall_3", "bo_eastern_wall_3", []),
("damask_arabian_wall_a", 0, "damask_arabian_wall_a", "bo_arabian_wall_a", []),
("damask_arabian_wall_a_1", 0, "damask_arabian_wall_a_1", "bo_damask_arabian_wall_a_1", []),
("damask_arabian_wall_a_var1", 0, "damask_arabian_wall_a_var1", "bo_arabian_wall_a", []),
("damask_arabian_wall_a_1_var1", 0, "damask_arabian_wall_a_1_var1", "bo_damask_arabian_wall_a_1", []),
("damask_stone_house_f", 0, "damask_stone_house_f", "bo_damask_stone_house_f", []),
("damask_sa_minaret", 0, "damask_sa_minaret", "bo_damask_sa_minaret", []),
("damask_watch_tower_a", 0, "damask_watch_tower_a", "bo_damask_watch_tower_a", []),
("damask_superstructure_a", 0, "damask_superstructure_a", "bo_damask_superstructure_a", []),
("damask_superstructure_a_var1", 0, "damask_superstructure_a_var1", "bo_damask_superstructure_a", []),
("damask_superstructure_b", 0, "damask_superstructure_b", "bo_damask_superstructure_b", []),
("damask_house_block_a", 0, "damask_house_block_a", "bo_damask_house_block_a", []),
("damask_house_block_b", 0, "damask_house_block_b", "bo_damask_house_block_b", []),
("damask_house_block_c", 0, "damask_house_block_c", "bo_damask_house_block_c", []),
("damask_house_block_c_var1", 0, "damask_house_block_c_var1", "bo_damask_house_block_c_var1", []),
("damask_house_block_c_var2", 0, "damask_house_block_c_var2", "bo_damask_house_block_c_var2", []),
("damask_arabian_house_f", 0, "damask_arabian_house_f", "bo_arabian_village_2_house_f", []),
("damask_arabian_house_g", 0, "damask_arabian_house_g", "bo_arabian_village_2_house_g", []),
("damask_arabian_house_g_var1", 0, "damask_arabian_house_g_var1", "bo_arabian_village_2_house_g", []),
("damask_arabian_house_g_var2", 0, "damask_arabian_house_g_var2", "bo_arabian_village_2_house_g", []),
("damask_arabian_house_h", 0, "damask_arabian_house_h", "bo_arabian_village_2_house_h", []),
("damask_arabian_house_h_var1", 0, "damask_arabian_house_h_var1", "bo_arabian_village_2_house_h", []),
("damask_arabian_house_i", 0, "damask_arabian_house_i", "bo_arabian_village_2_house_i", []),
("damask_arabian_house_i_var1", 0, "damask_arabian_house_i_var1", "bo_arabian_village_2_house_i", []),
("damask_arabian_house_a2", 0, "damask_arabian_house_a2", "bo_arabian_house_a2", []),
("damask_arabian_house_e", 0, "damask_arabian_house_e", "bo_arabian_village_2_house_e", []),
("damask_arabian_house_e_var1", 0, "damask_arabian_house_e_var1", "bo_arabian_village_2_house_e", []),
("damask_arabian_square_keep_a", 0, "damask_arabian_square_keep_a", "bo_arabian_square_keep_a", []),
("damask_arabian_square_keep_a_var1", 0, "damask_arabian_square_keep_a_var1", "bo_arabian_square_keep_a", []),
("damask_arabian_house_a", 0, "damask_arabian_house_a", "bo_arabian_house_a", []),
("damask_arabian_house_b", 0, "damask_arabian_house_b", "bo_arabian_house_b", []),
("damask_arabian_house_c", 0, "damask_arabian_house_c", "bo_arabian_house_c", []),
("damask_arabian_house_d", 0, "damask_arabian_house_d", "bo_arabian_house_d", []),
("damask_arabian_village_house_a", 0, "damask_arabian_village_house_a", "bo_arabian_village_house_a", []),
("damask_arabian_village_house_a_1", 0, "damask_arabian_village_house_a_1", "bo_damask_arabian_village_house_a_1", []),
("damask_arabian_village_house_b", 0, "damask_arabian_village_house_b", "bo_arabian_village_house_b", []),
("damask_arabian_village_house_c", 0, "damask_arabian_village_house_c", "bo_arabian_village_house_c", []),
("damask_arabian_village_house_d", 0, "damask_arabian_village_house_d", "bo_arabian_village_house_d", []),
("damask_arabian_house_extension_a", 0, "damask_arabian_house_extension_a", "bo_damask_arabian_house_extension_a", []),
("damask_arabian_house_extension_a_var1", 0, "damask_arabian_house_extension_a_var1", "bo_damask_arabian_house_extension_a", []),
("damask_arabian_house_extension_b", 0, "damask_arabian_house_extension_b", "bo_damask_arabian_house_extension_b", []),
("damask_arabian_house_extension_i", 0, "damask_arabian_house_extension_i", "bo_arabian_village_house_extension_i", []),
("damask_castle_house_a", 0, "damask_castle_house_a", "Jerusalem_castle_house_a_col", []),
("damask_castle_house_a_var1", 0, "damask_castle_house_a_var1", "Jerusalem_castle_house_a_col", []),
("damask_castle_house_b", 0, "damask_castle_house_b", "Jerusalem_castle_house_b_col", []),
("damask_castle_house_b_var1", 0, "damask_castle_house_b_var1", "Jerusalem_castle_house_b_col", []),
("damask_castle_house_c", 0, "damask_castle_house_c", "bo_castle_h_house_b", []),
("damask_castle_house_c_var1", 0, "damask_castle_house_c_var1", "bo_castle_h_house_b", []),
("damask_castle_house_d", 0, "damask_castle_house_d", "bo_castle_h_house_b", []),
("damask_castle_house_d_var1", 0, "damask_castle_house_d_var1", "bo_castle_h_house_b", []),
("damask_passage_house_a", 0, "damask_passage_house_a", "bo_arabian_passage_house_a", []),
("damask_passage_house_b", 0, "damask_passage_house_b", "bo_damask_passage_house_b", []),
("damask_passage_house_c", 0, "damask_passage_house_c", "bo_damask_passage_house_c", []),
("damask_passage_house_c_var1", 0, "damask_passage_house_c_var1", "bo_damask_passage_house_c", []),
("damask_klumba_a", 0, "damask_klumba_a", "bo_damask_klumba_a", []),
("damask_klumba_b", 0, "damask_klumba_b", "bo_damask_klumba_b", []),
("damask_klumba_c", 0, "damask_klumba_c", "bo_damask_klumba_c", []),
("damask_kolodec_a", 0, "damask_kolodec_a", "bo_damask_kolodec_a", []),
("damask_kolodec_b", 0, "damask_kolodec_b", "bo_damask_kolodec_b", []),
("damask_kolodec_c", 0, "damask_kolodec_c", "bo_damask_kolodec_c", []),
("damask_kolodec_d", 0, "damask_kolodec_d", "bo_damask_kolodec_d", []),
("damask_reshetka_1", 0, "damask_reshetka_1", "bo_damask_reshetka_1", []),
("damask_reshetka_2", 0, "damask_reshetka_2", "bo_damask_reshetka_2", []),

("damask_vorota_a", sokf_moveable, "damask_vorota_a", "damask_vorota_a_col", [
#    (ti_on_scene_prop_init,[
#      (store_trigger_param_1, ":var0"),
#      (scene_prop_get_instance, ":var1", "spr_damask_1_a", 0),
#      (prop_instance_get_position, pos1, ":var1"),
#      (try_begin),
#        (eq, "$g_gates_open", 1),
#        (position_move_z, pos1, 520),
#      (try_end),
#      (prop_instance_set_position, ":var0", pos1),
#      (store_current_scene, ":var2"),
#      (scene_set_slot, ":var2", 22, ":var0"),
#      (scene_set_slot, ":var2", 23, "spr_damask_ruins_vorota_a"),
#      (scene_set_slot, ":var2", 24, "spr_damask_ruins_vorota_n"),
#      (scene_prop_set_slot, ":var0", 23, 20),
#    ]),
  ]),

("damask_vorota_b", sokf_moveable, "damask_vorota_b", "damask_vorota_b_col", [
#    (ti_on_scene_prop_init,[
#      (store_trigger_param_1, ":var0"),
#      (scene_prop_get_instance, ":var1", "spr_damask_1_a", 0),
#      (prop_instance_get_position, pos1, ":var1"),
#      (position_move_z, pos1, 500),
#      (prop_instance_set_position, ":var0", pos1),
#    ]),
  ]),

("eastern_village_a", 0, "eastern_village_a", "bo_eastern_village_a", []),
("eastern_village_b", 0, "eastern_village_b", "bo_eastern_village_b", []),
("eastern_village_c", 0, "eastern_village_c", "bo_eastern_village_c", []),
("eastern_village_d", 0, "eastern_village_d", "bo_eastern_village_d", []),
("eastern_village_e", 0, "eastern_village_e", "bo_eastern_village_e", []),
("eastern_village_minaret_a", 0, "eastern_village_minaret_a", "bo_eastern_village_minaret_a", []),
("eastern_village_minaret_b", 0, "eastern_village_minaret_b", "bo_eastern_village_minaret_b", []),
("eastern_village_mechet_a", 0, "eastern_village_mechet_a", "bo_eastern_village_mechet_a", []),
("oasis_village_a", 0, "oasis_village_a", "bo_oasis_village_a", []),
("oasis_village_b", 0, "oasis_village_b", "bo_oasis_village_b", []),
("oasis_village_c", 0, "oasis_village_c", "bo_oasis_village_c", []),  

("arabian_cwe_house_1", 0, "arab_house_1", "bo_arab_house_1", []),
("arabian_cwe_house_2", 0, "arab_house_2", "bo_arab_house_2", []),
("arabian_cwe_carpet_shop", 0, "carpet_shop", "bo_carpet_shop", []),
("arabian_cwe_kamenolomna", 0, "kamenolomna", "bo_kamenolomna", []),
("arabian_cwe_mine", 0, "mine", "bo_mine", []),
("arabian_cwe_fountain", 0, "mark_fountain", "bo_mark_fountain", []),
("arabian_cwe_tent_1", 0, "tent_1", "bo_tent_1", []),
("arabian_cwe_tent_2", 0, "tent_2", "bo_tent_2", []),
  
# Jerusalem
("crusader_capellas_a", 0, "Capellas_a", "Capellas_a_col", []),
("Jerusalem_chapel_a", 0, "chapel_Jerusalem_a", "chapel_Jerusalem_a_col", []),
("crusader_chain_dome_a", 0, "Chain_dome_a", "Chain_dome_a_col", []),
("crusader_dome_of_the_Rock_a", 0, "Dome_of_the_Rock_a", "Dome_of_the_Rock_a_col", []),
("crusader_temple_mount_a", 0, "Temple_Mount_a", "Temple_Mount_a_col", []),
("crusader_skulptur_Maria", 0, "skulptur_Maria", "skulptur_Maria_col", []),
("crusader_gold_gate_a", 0, "gold_gate_a", "gold_gate_a_col", []),
("crusader_Al_Aksa", 0, "Al_Aksa", "Al_Aksa_col", []),
("crusader_Capellas_b", 0, "Capellas_b", "Capellas_b_col", []),
("crusader_Capellas_c", 0, "Capellas_c", "Capellas_c_col", []),
("crusader_Capellas_d", 0, "Capellas_d", "Capellas_d_col", []),
("crusader_Jerusalem_fontan_a", 0, "Jerusalem_fontan_a", "Jerusalem_fontan_a_col", []),
("crusader_water_river", 0, "crusader_water_river", "0", []),
("crusader_Jerusalem_ground_small_a", 0, "Jerusalem_ground_small_a", "Jerusalem_ground_small_a_col", []),
("crusader_Jerusalem_ground_a", 0, "Jerusalem_ground_a", "Jerusalem_ground_a_col", []),
("crusader_Jerusalem_ground_b", 0, "Jerusalem_ground_b", "Jerusalem_ground_b_col", []),
("crusader_Jerusalem_ground_c", 0, "Jerusalem_ground_c", "Jerusalem_ground_c_col", []),
("crusader_Jerusalem_ground_d", 0, "Jerusalem_ground_d", "Jerusalem_ground_d_col", []),
("crusader_Jerusalem_ground_e", 0, "Jerusalem_ground_e", "Jerusalem_ground_e_col", []),
("crusader_Jerusalem_stairs_small_a", 0, "Jerusalem_stairs_small_a", "Jerusalem_stairs_small_a_col", []),
("crusader_Jerusalem_stairs_small_b", 0, "Jerusalem_stairs_small_b", "Jerusalem_stairs_small_b_col", []),
("crusader_Jerusalem_stairs_small_c", 0, "Jerusalem_stairs_small_c", "Jerusalem_stairs_small_c_col", []),
("crusader_Jerusalem_stairs_medium_a", 0, "Jerusalem_stairs_medium_a", "Jerusalem_stairs_medium_a_col", []),
("crusader_Jerusalem_stairs_medium_b", 0, "Jerusalem_stairs_medium_b", "Jerusalem_stairs_medium_b_col", []),
("crusader_Jerusalem_stairs_medium_c", 0, "Jerusalem_stairs_medium_c", "Jerusalem_stairs_medium_c_col", []),
("crusader_Jerusalem_stairs_high_a", 0, "Jerusalem_stairs_high_a", "Jerusalem_stairs_high_a_col", []),
("crusader_Jerusalem_stairs_high_b", 0, "Jerusalem_stairs_high_b", "Jerusalem_stairs_high_b_col", []),
("crusader_Jerusalem_stairs_high_c", 0, "Jerusalem_stairs_high_c", "Jerusalem_stairs_high_c_col", []),
("crusader_Jerusalem_castle_house_a", 0, "Jerusalem_castle_house_a", "Jerusalem_castle_house_a_col", []),
("crusader_Jerusalem_castle_house_b", 0, "Jerusalem_castle_house_b", "Jerusalem_castle_house_b_col", []),
("crusader_Jerusalem_castle_house_c", 0, "Jerusalem_castle_house_c", "Jerusalem_castle_house_c_col", []),
("crusader_Jerusalem_castle_house_d", 0, "Jerusalem_castle_house_d", "Jerusalem_castle_house_d_col", []),
("crusader_chapel_Jerusalem_b", 0, "chapel_Jerusalem_b", "chapel_Jerusalem_b_col", []),
("crusader_level_dome_rock", 0, "level_dome_rock", "level_dome_rock_col", []),
("crusader_minaret_Jerusalem_a", 0, "minaret_Jerusalem_a", "minaret_Jerusalem_a_col", []),
("crusader_wall_gold_gate_a", 0, "wall_gold_gate_a", "wall_gold_gate_a_col", []),
("crusader_wall_gold_gate_b", 0, "wall_gold_gate_b", "wall_gold_gate_b_col", []),
("crusader_wall_gold_gate_c", 0, "wall_gold_gate_c", "wall_gold_gate_c_col", []),
("crusader_wall_gold_gate_d", 0, "wall_gold_gate_d", "wall_gold_gate_d_col", []),
("crusader_wall_gold_gate_e", 0, "wall_gold_gate_e", "wall_gold_gate_e_col", []),
("crusader_tower_gold_gate_a", 0, "tower_gold_gate_a", "tower_gold_gate_a_col", []),
("crusader_tower_gold_gate_b", 0, "tower_gold_gate_b", "tower_gold_gate_b_col", []),
("crusader_tower_gold_gate_c", 0, "tower_gold_gate_c", "tower_gold_gate_c_col", []),
("crusader_tower_gold_gate_d", 0, "tower_gold_gate_d", "tower_gold_gate_d_col", []),
("crusader_hram_jerusalem_a", 0, "hram_Jerusalem_a", "hram_Jerusalem_a_col", []),
("crusader_marcet_jerusalem_a", 0, "marcet_Jerusalem_a", "marcet_Jerusalem_a_col", []),
("crusader_royal_Palace_a", 0, "royal_Palace_a", "royal_Palace_a_col", []),
("crusader_sinagoga_Jerusalem_a", 0, "sinagoga_Jerusalem_a", "sinagoga_Jerusalem_a_col", []),
("crusader_fishing_boat", sokf_moveable, "fishing_boat", "0", []),

("eastern_house_with_interior_a", 0, "eastern_house_with_interior_a", "bo_eastern_house_with_interior_a", []),
("eastern_house_with_interior_a_var_1", 0, "eastern_house_with_interior_a_var_1", "bo_eastern_house_with_interior_a_var_1", []),
("eastern_house_with_interior_a_var_2", 0, "eastern_house_with_interior_a_var_2", "bo_eastern_house_with_interior_a_var_2", []),
("eastern_house_with_interior_a_var_3", 0, "eastern_house_with_interior_a_var_3", "bo_eastern_house_with_interior_a_var_3", []),
("eastern_house_with_interior_a_var_4", 0, "eastern_house_with_interior_a_var_4", "bo_eastern_house_with_interior_a_var_4", []),
("eastern_house_with_interior_a_var_5", 0, "eastern_house_with_interior_a_var_5", "bo_eastern_house_with_interior_a_var_5", []),
("eastern_house_with_interior_b", 0, "eastern_house_with_interior_b", "bo_eastern_house_with_interior_b", []),
("eastern_house_with_interior_b_open_var1", 0, "eastern_house_with_interior_b_open_var1", "bo_eastern_house_with_interior_b_open_var1", []),
("eastern_house_with_interior_b_open_var2", 0, "eastern_house_with_interior_b_open_var2", "bo_eastern_house_with_interior_b_open_var2", []),
("eastern_house_with_interior_c", 0, "eastern_house_with_interior_c", "bo_eastern_house_with_interior_c", []),
("eastern_house_with_interior_c_var1", 0, "eastern_house_with_interior_c_var1", "bo_eastern_house_with_interior_c", []),
("eastern_house_with_interior_d", 0, "eastern_house_with_interior_d", "bo_eastern_house_with_interior_d", []),
("eastern_house_with_interior_d_var1", 0, "eastern_house_with_interior_d_var1", "bo_eastern_house_with_interior_d", []),
("eastern_house_with_interior_e", 0, "eastern_house_with_interior_e", "bo_eastern_house_with_interior_e", []),
("eastern_house_with_interior_f", 0, "eastern_house_with_interior_f", "bo_eastern_house_with_interior_f", []),
("eastern_house_with_interior_g", 0, "eastern_house_with_interior_g", "bo_eastern_house_with_interior_g", []),
("eastern_house_with_interior_s", 0, "eastern_house_with_interior_s", "bo_eastern_house_with_interior_s", []),
("eastern_building_with_interior_a", 0, "eastern_building_with_interior_a", "bo_eastern_building_with_interior_a", []),
("eastern_building_with_interior_b", 0, "eastern_building_with_interior_b", "bo_eastern_building_with_interior_b", []),
("eastern_house_with_interior_cloth_a", 0, "eastern_house_with_interior_cloth_a", "0", []),
("eastern_ground_a", 0, "eastern_ground_a", "bo_eastern_ground_a", []),
("eastern_wall_1", 0, "eastern_wall_1", "bo_eastern_wall_1", []),
("eastern_wall_2", 0, "eastern_wall_2", "bo_eastern_wall_2", []),
("eastern_wall_3", 0, "eastern_wall_3", "bo_eastern_wall_3", []),
("eastern_wall_b_1", 0, "eastern_wall_b_1", "bo_eastern_wall_b_1", []),
("eastern_wall_b_2", 0, "eastern_wall_b_2", "bo_eastern_wall_b_2", []),
("eastern_wall_b_3", 0, "eastern_wall_b_3", "bo_eastern_wall_b_3", []),

# Acre
("akra_cargo_crane", 0, "cargo_crane", "cargo_crane_col", []),
("akra_chapel_a", 0, "chapel_Acr_a", "chapel_Acr_a_col", []),
("akra_square_tower_akr_a", 0, "square_tower_Akr_a", "square_tower_Akr_a_col", []),
("akra_square_tower_akr_b", 0, "square_tower_Akr_b", "square_tower_Akr_b_col", []),
("akra_square_tower_akr_c", 0, "square_tower_Akr_c", "square_tower_Akr_c_col", []),
("akra_square_tower_akr_d", 0, "square_tower_Akr_d", "square_tower_Akr_d_col", []),
("akra_square_tower_akr_e", 0, "square_tower_Akr_e", "square_tower_Akr_e_col", []),
("akra_square_tower_akr_f", 0, "square_tower_Akr_f", "square_tower_Akr_f_col", []),
("akra_sea_gate", 0, "sea_gate", "sea_gate_col", []),
("akra_main_gate", 0, "main_gate_Acre", "main_gate_Acre_col", []),
("akra_main_gate_a", 0, "akra_vorota_a", "bo_akra_vorota_a", []),
("akra_main_gate_b", 0, "akra_vorota_b", "bo_akra_vorota_b", []),
("akra_main_gate_c", 0, "akra_vorota_c", "bo_akra_vorota_c", []),
("akra_round_tower_a", 0, "akra_round_tower_a", "akra_round_tower_a_col", []),
("akra_round_tower_b", 0, "akra_round_tower_b", "akra_round_tower_b_col", []),
("akra_round_tower_c", 0, "akra_round_tower_c", "0", []),
("akra_round_tower_d", 0, "akra_round_tower_d", "0", []),
("akra_port_akr", 0, "port_Akr", "port_Akr_col", []),
("akra_wall_sea_akr_a", 0, "wall_sea_Akr_a", "wall_sea_Akr_a_col", []),
("akra_wall_sea_akr_b", 0, "wall_sea_Akr_b", "wall_sea_Akr_b_col", []),
("akra_fort_akr_a", 0, "fort_Akr_a", "fort_Akr_a_col", []),
("akra_beacon_acr", 0, "beacon_Acr", "beacon_Acr_col", []),

# Miscellaneous
("crusader_korzina_1", 0, "korzina_1", "korzina_1_col", []),
("crusader_svet_vostok_1_a", 0, "svet_vostok_1_a", "svet_vostok_1_a_col", []),
("crusader_city_detals_1_a", 0, "city_detals_1_a", "city_detals_1_a_col", []),
("crusader_city_detals_2_b", 0, "city_detals_2_b", "city_detals_2_b_col", []),
("crusader_old_horse_a", 0, "old_horse_a", "old_horse_a_col", []),
("crusader_ruins_a", 0, "ruins_a", "ruins_a_col", []),
#SoF
("crusader_details_butcher_a", 0, "details_butcher_a", "details_butcher_a_col", []),
("crusader_details_butcher_b", 0, "details_butcher_b", "details_butcher_b_col", []),
("crusader_details_butcher_c", 0, "details_butcher_c", "details_butcher_c_col", []),
("crusader_details_butcher_d", 0, "details_butcher_d", "details_butcher_d_col", []),
("crusader_details_butcher_e", 0, "details_butcher_e", "details_butcher_e_col", []),
("crusader_details_butcher_f", 0, "details_butcher_f", "details_butcher_f_col", []),
("crusader_details_butcher_g", 0, "details_butcher_g", "details_butcher_g_col", []),
("crusader_details_butcher_h", 0, "details_butcher_h", "details_butcher_h_col", []),
("crusader_details_butcher_k", 0, "details_butcher_k", "details_butcher_k_col", []),

("crusader_chili", 0, "chili", "chili_col", []),
("crusader_garlic", 0, "garlic", "garlic_col", []),

("crusader_kitchen_herbs_a", 0, "kitchen_herbs_a", "kitchen_herbs_a_col", []),
("crusader_kitchen_herbs_b", 0, "kitchen_herbs_b", "kitchen_herbs_b_col", []),
("crusader_kitchen_herbs_c", 0, "kitchen_herbs_c", "kitchen_herbs_c_col", []),
("crusader_kitchen_herbs_d", 0, "kitchen_herbs_d", "kitchen_herbs_d_col", []),
("crusader_kitchen_herbs_e", 0, "kitchen_herbs_e", "kitchen_herbs_e_col", []),
("crusader_kitchen_herbs_f", 0, "kitchen_herbs_f", "kitchen_herbs_f_col", []),
("crusader_kitchen_herbs_g", 0, "kitchen_herbs_g", "kitchen_herbs_g_col", []),
("crusader_kitchen_herbs_h", 0, "kitchen_herbs_h", "kitchen_herbs_h_col", []),
("crusader_kitchen_herbs_k", 0, "kitchen_herbs_k", "kitchen_herbs_k_col", []),
("crusader_kitchen_herbs_l", 0, "kitchen_herbs_l", "kitchen_herbs_l_col", []),
("crusader_kitchen_herbs_m", 0, "kitchen_herbs_m", "kitchen_herbs_m_col", []),
("crusader_kitchen_herbs_n", 0, "kitchen_herbs_n", "kitchen_herbs_n_col", []),
("crusader_kitchen_herbs_o", 0, "kitchen_herbs_o", "kitchen_herbs_o_col", []),
("crusader_kitchen_herbs_p", 0, "kitchen_herbs_p", "kitchen_herbs_p_col", []),
("crusader_kitchen_herbs_q", 0, "kitchen_herbs_q", "kitchen_herbs_q_col", []),
("crusader_kitchen_herbs_r", 0, "kitchen_herbs_r", "kitchen_herbs_r_col", []),
("crusader_kitchen_herbs_s", 0, "kitchen_herbs_s", "kitchen_herbs_s_col", []),
("crusader_kitchen_herbs_t", 0, "kitchen_herbs_t", "kitchen_herbs_t_col", []),
("crusader_kitchen_herbs_u", 0, "kitchen_herbs_u", "kitchen_herbs_u_col", []),
("crusader_kitchen_herbs_v", 0, "kitchen_herbs_v", "kitchen_herbs_v_col", []),

("crusader_spoon_fo_seasoning", 0, "spoon_fo_seasoning", "spoon_fo_seasoning_col", []),
("crusader_scales_a", 0, "scales_a", "scales_a_col", []),

("crusader_refined_pitcher_a", 0, "refined_pitcher_a", "refined_pitcher_a_col", []),
("crusader_refined_pitcher_b", 0, "refined_pitcher_b", "refined_pitcher_b_col", []),
("crusader_refined_pitcher_c", 0, "refined_pitcher_c", "refined_pitcher_c_col", []),
("crusader_refined_pitcher_d", 0, "refined_pitcher_d", "refined_pitcher_d_col", []),
("crusader_refined_pitcher_e", 0, "refined_pitcher_e", "refined_pitcher_e_col", []),
("crusader_refined_pitcher_f", 0, "refined_pitcher_f", "refined_pitcher_f_col", []),

("crusader_exquisite_dish_a", 0, "exquisite_dish_a", "exquisite_dish_a_col", []),
("crusader_exquisite_dish_b", 0, "exquisite_dish_b", "exquisite_dish_b_col", []),
("crusader_exquisite_dish_c", 0, "exquisite_dish_c", "exquisite_dish_c_col", []),
("crusader_exquisite_dish_d", 0, "exquisite_dish_d", "exquisite_dish_d_col", []),
("crusader_exquisite_dish_e", 0, "exquisite_dish_e", "exquisite_dish_e_col", []),

("crusader_exquisite_cup_a", 0, "exquisite_cup_a", "exquisite_cup_a_col", []),
("crusader_exquisite_cup_b", 0, "exquisite_cup_b", "exquisite_cup_b_col", []),

("crusader_elegant_lamp_a", 0, "elegant_lamp_a", "elegant_lamp_a_col", []),
("crusader_elegant_lamp_b", 0, "elegant_lamp_b", "elegant_lamp_b_col", []),
("crusader_elegant_lamp_c", 0, "elegant_lamp_c", "elegant_lamp_c_col", []),
("crusader_elegant_lamp_d", 0, "elegant_lamp_d", "elegant_lamp_d_col", []),
#SoF end

("crusader_svet_tower_a", 0, "svet_tower_a", "svet_tower_a_col", [
    (ti_on_scene_prop_init,[
#      (store_time_of_day, reg12),
#      (this_or_next|is_between, "$g_quick_dt", 0, 7),
#      (this_or_next|is_between, "$g_quick_dt", 20, 24),
#      (neg|is_between, reg12, 6, 20),
      (set_position_delta, 0, 0, 25),
      (particle_system_add_new, "psys_brazier_fire_1"),
      (particle_system_add_new, "psys_fire_sparks_1"),
#      (set_position_delta, 0, 0, 70),
#      (particle_system_add_new, "psys_fire_glow_1"),
#      (particle_system_emit, "psys_fire_glow_1", 9000000),
    ]),
  ]),
#SoF
("crusader_svet_tower_b", 0, "svet_tower_b", "svet_tower_b_col", []), 
("crusader_cog_a", 0, "crusader_cog_a", "bo_crusader_cog_a", []), 
("crusader_cog_a_sall_off", 0, "crusader_cog_a_sall_off", "bo_crusader_cog_a_sall_off", []),
("crusader_holy_cross", 0, "holy_cross", "bo_Holy_Cross", []),
#SoF end
("sa_sp_end", 0, "0", "0", [
    (ti_on_scene_prop_init,[
      (particle_system_add_new, "psys_fall_leafs_a"),
    ]),
  ]),
("ship", sokf_moveable, "ship", "bo_ship", [
    (ti_on_scene_prop_hit,[
      (play_sound, "snd_dummy_hit"),
      (particle_system_burst, "psys_dummy_smoke", pos1, 3),
      (particle_system_burst, "psys_dummy_straw", pos1, 10),
    ]),
  ]),
("ship_b", sokf_moveable, "ship_b", "bo_ship_b", [
    (ti_on_scene_prop_hit,[
      (play_sound, "snd_dummy_hit"),
      (particle_system_burst, "psys_dummy_smoke", pos1, 3),
      (particle_system_burst, "psys_dummy_straw", pos1, 10),
    ]),
  ]),
("ship_c", sokf_moveable, "crusader_cog_a", "bo_crusader_cog_a", [
    (ti_on_scene_prop_hit,[
      (play_sound, "snd_dummy_hit"),
      (particle_system_burst, "psys_dummy_smoke", pos1, 3),
      (particle_system_burst, "psys_dummy_straw", pos1, 10),
    ]),
  ]),
("ship_d", sokf_moveable, "ship_d", "bo_ship_d", [
    (ti_on_scene_prop_hit,[
      (play_sound, "snd_dummy_hit"),
      (particle_system_burst, "psys_dummy_smoke", pos1, 3),
      (particle_system_burst, "psys_dummy_straw", pos1, 10),
    ]),
  ]),
("ship_for_sieges", sokf_moveable, "ship_for_sieges", "ship_for_sieges_col", []),
("ship_for_sieges_oar", sokf_moveable, "oar", "oar_col", []),
("ship_for_sieges_mechanism", sokf_moveable, "mechanism_for_sieges", "mechanism_for_sieges_col", []),
("ship_for_sieges_ladder", sokf_moveable, "ship_ladder", "ship_ladder_col", []),
("ship_sail_off", 0, "ship_sail_off", "bo_ship_sail_off", []),
("ship_sail_off_b", 0, "ship_sail_off_b", "bo_ship_sail_off", []),
("ship_c_sail_off", 0, "ship_c_sail_off", "bo_ship_c_sail_off", []),
("ship_ramp_a", sokf_moveable, "ship_ramp_a", "bo_ship_ramp_a", [
    (ti_on_scene_prop_hit,[
      (play_sound, "snd_dummy_hit"),
      (particle_system_burst, "psys_dummy_smoke", pos1, 3),
      (particle_system_burst, "psys_dummy_straw", pos1, 10),
    ]),
  ]),
("ship_torch_night", sokf_moveable, "torch_a", "0", [
    (ti_on_scene_prop_init,[
      (is_currently_night, 0),
      (set_position_delta, 0, -35, 48),
      (particle_system_add_new, "psys_torch_fire"),
      (particle_system_add_new, "psys_torch_smoke"),
      (particle_system_add_new, "psys_torch_fire_sparks"),
      (set_position_delta, 0, -35, 56),
      (particle_system_add_new, "psys_fire_glow_1"),
      (particle_system_emit, "psys_fire_glow_1", 9000000),
      (play_sound, "snd_torch_loop", 0),
    ]),
  ]),
("ship_light_red", sokf_invisible, "light_sphere", "0", [
    (ti_on_scene_prop_init,[
      (store_trigger_param_1, ":var0"),
      (set_fixed_point_multiplier, 100),
      (prop_instance_get_scale, pos5, ":var0"),
      (position_get_scale_x, ":var1", pos5),
      (store_mul, ":var2", 340, ":var1"),
      (store_mul, ":var3", 200, ":var1"),
      (store_mul, ":var4", 60, ":var1"),
      (val_div, ":var2", 100),
      (val_div, ":var3", 100),
      (val_div, ":var4", 100),
      (set_current_color, ":var2", ":var3", ":var4"),
      (set_position_delta, 0, 0, 0),
      (add_point_light_to_entity, 20, 30),
    ]),
  ]),
("ship_catapult_destructible", sokf_show_hit_point_bar|sokf_destructible|sokf_moveable, "Catapult", "bo_Catapult", [
    (ti_on_scene_prop_init,[
      (store_trigger_param_1, ":var0"),
      (scene_prop_set_hit_points, ":var0", 500),
    ]),

    (ti_on_scene_prop_destroy,[
      (play_sound, "snd_dummy_destroyed"),
      (store_trigger_param_1, ":var0"),
      (prop_instance_get_position, pos1, ":var0"),
      (particle_system_burst, "psys_dummy_smoke_big", pos1, 100),
      (particle_system_burst, "psys_dummy_straw_big", pos1, 100),
      (position_move_z, pos1, -100),
      (position_rotate_x, pos1, 90),
      (prop_instance_animate_to_position, ":var0", pos1, 300),
    ]),

    (ti_on_scene_prop_hit,[
      (store_trigger_param_1, ":var0"),
      (store_trigger_param_2, ":var1"),
      (try_begin),
        (scene_prop_get_hit_points, ":var2", ":var0"),
        (val_sub, ":var2", ":var1"),
        (gt, ":var2", 0),
        (play_sound, "snd_dummy_hit"),
        (particle_system_burst, "psys_dummy_smoke", pos1, 3),
        (particle_system_burst, "psys_dummy_straw", pos1, 10),
      (try_end),
    ]),
  ]),
("ship_tower_a", sokf_type_ladder|sokf_moveable, "castle_i_tower_a", "bo_castle_i_tower_a", []),
("ship_box_a_dynamic", sokf_moveable|sokf_dynamic_physics, "box_a", "bo_box_a", []),
("ship_obj_end", sokf_moveable, "box_a", "bo_box_a", []),
("ship_c_marker_team_0", 0, "crusader_cog_a", "0", []),
("ship_c_marker_team_1", 0, "crusader_cog_a", "0", []),
("ship_marker_end", 0, "crusader_cog_a", "0", []),
("ship_c_abordag_marker_team_0", 0, "crusader_cog_a", "0", []),
("ship_c_abordag_marker_team_1", 0, "crusader_cog_a", "0", []),
("ship_abordag_marker_end", 0, "crusader_cog_a", "0", []),

("pontoon_a", 0, "pontoon_a", "bo_pontoon_a", [
#    (ti_on_scene_prop_stepped_on,[
#      (store_trigger_param_1, ":var0"),
#      (store_trigger_param_2, ":var1"),
#      (try_begin),
#        (neg|agent_is_human, ":var0"),
#        (agent_get_rider, ":var2", ":var0"),
#        (assign, ":var3", 20),
#        (assign, ":var4", 30),
#        (try_begin),
#          (prop_instance_get_variation_id, ":var5", ":var1"),
#          (eq, ":var5", 1),
#          (assign, ":var3", 100),
#          (assign, ":var4", 100),
#        (try_end),
#        (try_begin),
#          (ge, ":var2", 0),
#          (agent_set_horse_speed_factor, ":var2", ":var4"),
#        (else_try),
#          (agent_set_speed_limit, ":var0", ":var3"),
#        (try_end),
#      (try_end),
#    ]),
  ]),

("pontoon_b", 0, "pontoon_b", "bo_pontoon_b", [
#    (ti_on_scene_prop_stepped_on,[
#      (store_trigger_param_1, ":var0"),
#      (store_trigger_param_2, ":var1"),
#      (try_begin),
#        (neg|agent_is_human, ":var0"),
#        (agent_get_rider, ":var2", ":var0"),
#        (assign, ":var3", 20),
#        (assign, ":var4", 30),
#        (try_begin),
#          (prop_instance_get_variation_id, ":var5", ":var1"),
#          (eq, ":var5", 1),
#          (assign, ":var3", 100),
#          (assign, ":var4", 100),
#        (try_end),
#        (try_begin),
#          (ge, ":var2", 0),
#          (agent_set_horse_speed_factor, ":var2", ":var4"),
#        (else_try),
#          (agent_set_speed_limit, ":var0", ":var3"),
#        (try_end),
#      (try_end),
#    ]),
  ]),

("siege_large_shield_taran", 0, "sa_siege_large_shield_a", "bo_sa_siege_large_shield_a", []),
("siege_large_shield_belfry", 0, "sa_siege_large_shield_a", "bo_sa_siege_large_shield_a", []),
("siege_large_shield_ladder", 0, "sa_siege_large_shield_a", "bo_sa_siege_large_shield_a", []),
("siege_wall_taran", 0, "sa_siege_wall_a", "bo_sa_siege_wall_a", []),
("siege_wall_belfry", 0, "sa_siege_wall_a", "bo_sa_siege_wall_a", []),
("siege_wall_ladder", 0, "sa_siege_wall_a", "bo_sa_siege_wall_a", []),
("siege_wall_defolt", 0, "sa_siege_wall_a", "bo_sa_siege_wall_a", []),
("ai_marker_player_attacker", sokf_invisible, "marker_red", "0", []),
("ai_marker_player_defender", sokf_invisible, "marker_green", "0", []),
("ai_marker_attacker_ladder_1", sokf_invisible, "ai_marker_inf_a_1", "0", []),
("ai_marker_attacker_ladder_10", sokf_invisible, "ai_marker_inf_a_10_new", "0", []),
("ai_marker_attacker_ladder_end", sokf_invisible, "ai_marker_inf_a_new_end", "0", []),
("ai_marker_attacker_archer_ladder_1", sokf_invisible, "ai_marker_arh_a_1", "0", []),
("ai_marker_attacker_archer_ladder_10", sokf_invisible, "ai_marker_arh_a_5_new", "0", []),
("ai_marker_attacker_archer_ladder_end", sokf_invisible, "ai_marker_arh_a_new_end", "0", []),
("ai_marker_defender_ladder_1", sokf_invisible, "ai_marker_inf_d_1", "0", []),
("ai_marker_defender_ladder_10", sokf_invisible, "ai_marker_inf_d_10_new", "0", []),
("ai_marker_defender_ladder_end", sokf_invisible, "ai_marker_inf_d_new_end", "0", []),
("ai_marker_defender_archer_ladder_1", sokf_invisible, "ai_marker_arh_d_1", "0", []),
("ai_marker_defender_archer_ladder_10", sokf_invisible, "ai_marker_arh_d_5_new", "0", []),
("ai_marker_defender_archer_ladder_end", sokf_invisible, "ai_marker_arh_d_new_end", "0", []),
("ai_marker_attacker_taran_1", sokf_invisible, "ai_marker_inf_a_1", "0", []),
("ai_marker_attacker_taran_10", sokf_invisible, "ai_marker_inf_a_10_new", "0", []),
("ai_marker_attacker_taran_end", sokf_invisible, "ai_marker_inf_a_new_end", "0", []),
("ai_marker_attacker_archer_taran_1", sokf_invisible, "ai_marker_arh_a_1", "0", []),
("ai_marker_attacker_archer_taran_10", sokf_invisible, "ai_marker_arh_a_5_new", "0", []),
("ai_marker_attacker_archer_taran_end", sokf_invisible, "ai_marker_arh_a_new_end", "0", []),
("ai_marker_defender_taran_1", sokf_invisible, "ai_marker_inf_d_1", "0", []),
("ai_marker_defender_taran_10", sokf_invisible, "ai_marker_inf_d_10_new", "0", []),
("ai_marker_defender_taran_end", sokf_invisible, "ai_marker_inf_d_new_end", "0", []),
("ai_marker_defender_archer_taran_1", sokf_invisible, "ai_marker_arh_d_1", "0", []),
("ai_marker_defender_archer_taran_10", sokf_invisible, "ai_marker_arh_d_5_new", "0", []),
("ai_marker_defender_archer_taran_end", sokf_invisible, "ai_marker_arh_d_new_end", "0", []),
("ai_marker_attacker_belfry_1", sokf_invisible, "ai_marker_inf_a_1", "0", []),
("ai_marker_attacker_belfry_10", sokf_invisible, "ai_marker_inf_a_10_new", "0", []),
("ai_marker_attacker_belfry_end", sokf_invisible, "ai_marker_inf_a_new_end", "0", []),
("ai_marker_attacker_archer_belfry_1", sokf_invisible, "ai_marker_arh_a_1", "0", []),
("ai_marker_attacker_archer_belfry_10", sokf_invisible, "ai_marker_arh_a_5_new", "0", []),
("ai_marker_attacker_archer_belfry_end", sokf_invisible, "ai_marker_arh_a_new_end", "0", []),
("ai_marker_defender_belfry_1", sokf_invisible, "ai_marker_inf_d_1", "0", []),
("ai_marker_defender_belfry_10", sokf_invisible, "ai_marker_inf_d_10_new", "0", []),
("ai_marker_defender_belfry_end", sokf_invisible, "ai_marker_inf_d_new_end", "0", []),
("ai_marker_defender_archer_belfry_1", sokf_invisible, "ai_marker_arh_d_1", "0", []),
("ai_marker_defender_archer_belfry_10", sokf_invisible, "ai_marker_arh_d_5_new", "0", []),
("ai_marker_defender_archer_belfry_end", sokf_invisible, "ai_marker_arh_d_new_end", "0", []),
("ai_marker_attacker_sally_1", sokf_invisible, "ai_marker_inf_a_1", "0", []),
("ai_marker_attacker_sally_10", sokf_invisible, "ai_marker_inf_a_10_new", "0", []),
("ai_marker_attacker_sally_end", sokf_invisible, "ai_marker_inf_a_new_end", "0", []),
("ai_marker_attacker_archer_sally_1", sokf_invisible, "ai_marker_arh_a_1", "0", []),
("ai_marker_attacker_archer_sally_10", sokf_invisible, "ai_marker_arh_a_5_new", "0", []),
("ai_marker_attacker_archer_sally_end", sokf_invisible, "ai_marker_arh_a_new_end", "0", []),
("ai_marker_defender_sally_1", sokf_invisible, "ai_marker_inf_d_1", "0", []),
("ai_marker_defender_sally_10", sokf_invisible, "ai_marker_inf_d_10_new", "0", []),
("ai_marker_defender_sally_end", sokf_invisible, "ai_marker_inf_d_new_end", "0", []),
("ai_marker_defender_archer_sally_1", sokf_invisible, "ai_marker_arh_d_1", "0", []),
("ai_marker_defender_archer_sally_10", sokf_invisible, "ai_marker_arh_d_5_new", "0", []),
("ai_marker_defender_archer_sally_end", sokf_invisible, "ai_marker_arh_d_new_end", "0", []),
("ai_marker_attac_reinforc_ladder", sokf_invisible, "ai_marker_inf_a_reinforc", "0", []),
("ai_marker_defend_reinforc_ladder", sokf_invisible, "ai_marker_inf_d_reinforc", "0", []),
("ai_marker_attac_reinforc_taran", sokf_invisible, "ai_marker_inf_a_reinforc", "0", []),
("ai_marker_defend_reinforc_taran", sokf_invisible, "ai_marker_inf_d_reinforc", "0", []),
("ai_marker_attac_reinforc_belfry", sokf_invisible, "ai_marker_inf_a_reinforc", "0", []),
("ai_marker_defend_reinforc_belfry", sokf_invisible, "ai_marker_inf_d_reinforc", "0", []),
("ai_marker_attac_reinforc_sally", sokf_invisible, "ai_marker_inf_a_reinforc", "0", []),
("ai_marker_defend_reinforc_sally", sokf_invisible, "ai_marker_inf_d_reinforc", "0", []),
("ai_sa_marker_belfry_begin", sokf_invisible, "marker_belfry_begin", "0", []),
("ai_sa_marker_belfry", sokf_invisible, "marker_belfry", "0", []),
("ai_sa_marker_belfry_end", sokf_invisible, "marker_belfry_end", "0", []),
("ai_sa_marker_ram_begin", sokf_invisible, "marker_ram_begin", "0", []),
("ai_sa_marker_ram", sokf_invisible, "marker_ram", "0", []),
("ai_sa_marker_ram_end", sokf_invisible, "marker_ram_end", "0", []),
("ai_flag_reinforc_attac", sokf_moveable|sokf_face_player, "ai_flag_reinforc_attac", "0", []),
("ai_flag_reinforc_defend", sokf_moveable|sokf_face_player, "ai_flag_reinforc_defend", "0", []),
("ai_flag_reinforc_defolt", sokf_moveable|sokf_face_player, "ai_flag_reinforc_defolt", "0", []),
("ai_marker_battle_postroenie_1", sokf_invisible, "ai_marker_inf_d_1", "0", []),
("ai_marker_battle_postroenie_2", sokf_invisible, "ai_marker_inf_a_1", "0", []),
("ai_flag_battle_points_archer", sokf_invisible, "ai_marker_inf_d_1", "0", []),
("ai_flag_battle_points_inf", sokf_invisible, "ai_marker_inf_a_1", "0", []),
("ai_marker_ladder_belfry", sokf_invisible, "ai_marker_ladder_belfry", "0", []),
("ballist", 0, "ballist", "bo_ballist", []),
  
("crusader_water_river", 0, "crusader_water_river", "0", []),
("mat_ground_marker_gray_stone", sokf_invisible, "ground_marker_gray_stone", "0", []),
("mat_ground_marker_brown_stone", sokf_invisible, "ground_marker_brown_stone", "0", []),
("mat_ground_marker_turf", sokf_invisible, "ground_marker_turf", "0", []),
("mat_ground_marker_steppe", sokf_invisible, "ground_marker_steppe", "0", []),
("mat_ground_marker_snow", sokf_invisible, "ground_marker_snow", "0", []),
("mat_ground_marker_earth", sokf_invisible, "ground_marker_earth", "0", []),
("mat_ground_marker_desert", sokf_invisible, "ground_marker_desert", "0", []),
("mat_ground_marker_forest", sokf_invisible, "ground_marker_forest", "0", []),
("mat_ground_marker_pebbles", sokf_invisible, "ground_marker_pebbles", "0", []),
("mat_ground_marker_village", sokf_invisible, "ground_marker_village", "0", []),
("mat_ground_marker_path", sokf_invisible, "ground_marker_path", "0", []),
("mat_ground_marker_water", sokf_invisible, "ground_marker_water", "0", []),
("mat_marker_building", sokf_invisible, "ground_marker_gray_stone", "0", []),
("village_remove_marker_manor", sokf_invisible|sokf_face_player, "sa_barrier_sphere", "0", []),
("village_remove_marker_watch_tower", sokf_invisible|sokf_face_player, "sa_barrier_sphere", "0", []),
("village_remove_marker_messenger_post", sokf_invisible|sokf_face_player, "sa_barrier_sphere", "0", []),
("village_remove_marker_golubiatnia", sokf_invisible|sokf_face_player, "sa_barrier_sphere", "0", []),
("village_remove_marker_patrol_post", sokf_invisible|sokf_face_player, "sa_barrier_sphere", "0", []),
("village_remove_marker_cerkov", sokf_invisible|sokf_face_player, "sa_barrier_sphere", "0", []),
("village_remove_marker_mechet", sokf_invisible|sokf_face_player, "sa_barrier_sphere", "0", []),
("village_remove_marker_horse_mill", sokf_invisible|sokf_face_player, "sa_barrier_sphere", "0", []),
("village_remove_marker_wind_mill", sokf_invisible|sokf_face_player, "sa_barrier_sphere", "0", []),
("village_remove_marker_smithy", sokf_invisible|sokf_face_player, "sa_barrier_sphere", "0", []),
("village_remove_marker_production_charcoal", sokf_invisible|sokf_face_player, "sa_barrier_sphere", "0", []),
("village_remove_marker_wheat", sokf_invisible|sokf_face_player, "sa_barrier_sphere", "0", []),
("village_remove_marker_animal_farm", sokf_invisible|sokf_face_player, "sa_barrier_sphere", "0", []),
("village_remove_marker_cotton", sokf_invisible|sokf_face_player, "sa_barrier_sphere", "0", []),
("village_remove_marker_flax", sokf_invisible|sokf_face_player, "sa_barrier_sphere", "0", []),
("village_remove_marker_sugarcane", sokf_invisible|sokf_face_player, "sa_barrier_sphere", "0", []),
("village_remove_marker_olive", sokf_invisible|sokf_face_player, "sa_barrier_sphere", "0", []),
("village_remove_marker_orchard", sokf_invisible|sokf_face_player, "sa_barrier_sphere", "0", []),
("village_remove_marker_vineyard", sokf_invisible|sokf_face_player, "sa_barrier_sphere", "0", []),
("village_remove_marker_stone_pit", sokf_invisible|sokf_face_player, "sa_barrier_sphere", "0", []),
("village_remove_marker_logging", sokf_invisible|sokf_face_player, "sa_barrier_sphere", "0", []),
("village_remove_marker_clay_pit", sokf_invisible|sokf_face_player, "sa_barrier_sphere", "0", []),
("village_remove_marker_end", sokf_invisible|sokf_face_player, "sa_barrier_sphere", "0", []),
("sea_waves_effect", 0, "sea_waves_effect", "0", []),
("desert_waterfall", 0, "desert_waterfall", "0", []),

#("birds_woron_flight", sokf_moveable|sokf_dynamic_physics, "woron_flight", "bo_woron_flight", [
#    (ti_on_scene_prop_init,[
#      (store_trigger_param_1, ":var0"),
#      (assign, ":var1", 25),
#      (scene_prop_set_slot, ":var0", 40, ":var1"),
#      (val_add, ":var1", 1),
#      (store_random_in_range, ":var2", 1, ":var1"),
#      (scene_prop_set_slot, ":var0", 37, ":var2"),
#      (store_random_in_range, ":var3", 0, 16),
#      (val_mul, ":var3", 80),
#      (scene_prop_set_slot, ":var0", 39, ":var3"),
#      (scene_prop_set_slot, ":var0", 42, 8),
#      (scene_prop_set_slot, ":var0", 43, 11),
#      (scene_prop_set_slot, ":var0", 44, -1),
#    ]),

#    (ti_on_scene_prop_hit,[
#      (store_trigger_param_1, ":var0"),
#      (call_script, "script_sa_flying_birds_hit", ":var0"),
#    ]),
#  ]),

#("birds_golub_flight", sokf_moveable|sokf_dynamic_physics, "golub_flight", "bo_golub_flight", [
#    (ti_on_scene_prop_init,[
#      (store_trigger_param_1, ":var0"),
#      (assign, ":var1", 26),
#      (scene_prop_set_slot, ":var0", 40, ":var1"),
#      (val_add, ":var1", 1),
#      (store_random_in_range, ":var2", 1, ":var1"),
#      (scene_prop_set_slot, ":var0", 37, ":var2"),
#      (store_random_in_range, ":var3", 0, 16),
#      (val_mul, ":var3", 80),
#      (scene_prop_set_slot, ":var0", 39, ":var3"),
#      (scene_prop_set_slot, ":var0", 42, 9),
#      (scene_prop_set_slot, ":var0", 43, 12),
#      (scene_prop_set_slot, ":var0", 44, -1),
#    ]),

#    (ti_on_scene_prop_hit,[
#      (store_trigger_param_1, ":var0"),
#      (call_script, "script_sa_flying_birds_hit", ":var0"),
#    ]),
#  ]),

#("birds_marker_woron_flight", sokf_invisible, "woron", "0", [
#    (ti_on_scene_prop_init,[
#      (store_trigger_param_1, ":var0"),
#      (try_begin),
#        (eq, "$g_disable_flying_birds", 0),
#        (set_fixed_point_multiplier, 100),
#        (prop_instance_get_position, pos1, ":var0"),
#        (prop_instance_get_variation_id, ":var1", ":var0"),
#        (prop_instance_get_variation_id_2, ":var2", ":var0"),
#        (try_begin),
#          (eq, ":var1", 0),
#          (assign, ":var1", 1),
#        (else_try),
#          (ge, ":var1", 11),
#          (assign, ":var1", 11),
#        (try_end),
#        (assign, ":var3", 0),
#        (try_for_range, ":var4", 0, ":var1"),
#          (position_rotate_z, pos1, ":var3"),
#          (set_spawn_position, pos1),
#          (spawn_scene_prop, "spr_birds_woron_flight"),
#          (scene_prop_set_slot, reg0, 44, ":var0"),
#          (prop_instance_enable_physics, reg0, 0),
#          (val_add, ":var3", 32),
#          (try_begin),
#            (eq, ":var2", 1),
#            (scene_prop_set_slot, reg0, 45, 1),
#          (try_end),
#        (try_end),
#      (try_end),
#    ]),
#  ]),

#("birds_marker_golub_flight", sokf_invisible, "golub", "0", [
#    (ti_on_scene_prop_init,[
#      (store_trigger_param_1, ":var0"),
#      (try_begin),
#        (eq, "$g_disable_flying_birds", 0),
#        (set_fixed_point_multiplier, 100),
#        (prop_instance_get_position, pos1, ":var0"),
#        (prop_instance_get_variation_id, ":var1", ":var0"),
#        (prop_instance_get_variation_id_2, ":var2", ":var0"),
#        (try_begin),
#          (eq, ":var1", 0),
#          (assign, ":var1", 1),
#        (else_try),
#          (ge, ":var1", 11),
#          (assign, ":var1", 11),
#        (try_end),
#        (assign, ":var3", 0),
#        (try_for_range, ":var4", 0, ":var1"),
#          (position_rotate_z, pos1, ":var3"),
#          (set_spawn_position, pos1),
#          (spawn_scene_prop, "spr_birds_golub_flight"),
#          (scene_prop_set_slot, reg0, 44, ":var0"),
#          (prop_instance_enable_physics, reg0, 0),
#          (val_add, ":var3", 1),
#          (try_begin),
#            (eq, ":var2", 1),
#            (scene_prop_set_slot, reg0, 45, 1),
#          (try_end),
#        (try_end),
#      (try_end),
#    ]),
#  ]),

#  ("anim_corneille",0,"0","0",
#   [
#   (ti_on_scene_prop_init,    
    
#    [
#      (try_begin),
#          (store_time_of_day, ":cur_hour"),
#          (ge, ":cur_hour", 5),
#          (lt, ":cur_hour", 21), 
        
     #(call_script, "script_heure_oiseaux"),          
#     (particle_system_add_new, "psys_corneilles"),
#        (try_end),      
#    ]),
#   ]),

#  ("anim_goeland",0,"0","0",
#   [
#   (ti_on_scene_prop_init,
   
#    [
#      (try_begin),
#          (store_time_of_day, ":cur_hour"),
#          (ge, ":cur_hour", 5),
#          (lt, ":cur_hour", 21), 
#     (particle_system_add_new, "psys_goeland"),      
#        (try_end),      
#    ]),
#   ]),


#  ("soundbox_goeland",0,"0","0",
#   [
#   (ti_on_scene_prop_init,
   
#    [
#      (try_begin),
#          (store_time_of_day, ":cur_hour"),
#          (ge, ":cur_hour", 5),
#          (lt, ":cur_hour", 21), 
#         (play_sound, "snd_mouettes", sf_looping),      
#        (try_end),      
#    ]),
#   ]),


#  ("soundbox_mer",0,"0","0",
#   [
#   (ti_on_scene_prop_init,
   
#    [
#         (play_sound, "snd_mer", sf_looping),            
#    ]),
#   ]),

]
# modmerger_start version=201 type=2
try:
    component_name = "scene_props"
    var_set = { "scene_props" : scene_props }
    from modmerger import modmerge
    modmerge(var_set)
except:
    raise
# modmerger_end
